/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PackedOffsets
implements Loggable {
    private short[] data;
    private int size;

    Iterator iterator() {
        return new Iterator();
    }

    public void pack(long[] offsets) {
        short[] newData = new short[offsets.length * 3];
        Arrays.sort(offsets);
        int dataIndex = 0;
        long priorVal = 0L;
        int i = 0;
        while (i < offsets.length) {
            long val = offsets[i];
            dataIndex = this.append(newData, dataIndex, val - priorVal);
            priorVal = val;
            ++i;
        }
        this.data = new short[dataIndex];
        System.arraycopy(newData, 0, this.data, 0, dataIndex);
        this.size = offsets.length;
    }

    long[] toArray() {
        long[] offsets = new long[this.size];
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            offsets[index++] = iter.next();
        }
        assert (index == this.size);
        return offsets;
    }

    private int append(short[] to, int index, long val) {
        short s;
        assert (val >= 0L);
        while (true) {
            s = (short)(val & 0x7FFFL);
            if ((val >>>= 15) <= 0L) break;
            to[index++] = (short)(-1 - s);
        }
        to[index++] = s;
        return index;
    }

    public int getExtraMemorySize() {
        if (this.data != null) {
            return MemoryBudget.shortArraySize(this.data.length);
        }
        return 0;
    }

    @Override
    public int getLogSize() {
        int len = this.data != null ? this.data.length : 0;
        return LogUtils.getPackedIntLogSize(this.size) + LogUtils.getPackedIntLogSize(len) + len * 2;
    }

    @Override
    public void writeToLog(ByteBuffer buf) {
        LogUtils.writePackedInt(buf, this.size);
        if (this.data != null) {
            LogUtils.writePackedInt(buf, this.data.length);
            int i = 0;
            while (i < this.data.length) {
                LogUtils.writeShort(buf, this.data[i]);
                ++i;
            }
        } else {
            LogUtils.writePackedInt(buf, 0);
        }
    }

    @Override
    public void readFromLog(ByteBuffer buf, byte entryVersion) {
        boolean unpacked = entryVersion < 6;
        this.size = LogUtils.readInt(buf, unpacked);
        int len = LogUtils.readInt(buf, unpacked);
        if (len > 0) {
            this.data = new short[len];
            int i = 0;
            while (i < len) {
                this.data[i] = LogUtils.readShort(buf);
                ++i;
            }
        }
    }

    @Override
    public void dumpLog(StringBuffer buf, boolean verbose) {
        if (this.size > 0) {
            Iterator i = this.iterator();
            buf.append("<offsets size=\"");
            buf.append(this.size);
            buf.append("\">");
            while (i.hasNext()) {
                buf.append("0x");
                buf.append(Long.toHexString(i.next()));
                buf.append(' ');
            }
            buf.append("</offsets>");
        } else {
            buf.append("<offsets size=\"0\"/>");
        }
    }

    @Override
    public long getTransactionId() {
        return -1L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.dumpLog(buf, true);
        return buf.toString();
    }

    class Iterator {
        private int index;
        private long priorVal;

        private Iterator() {
        }

        boolean hasNext() {
            return PackedOffsets.this.data != null && this.index < PackedOffsets.this.data.length;
        }

        long next() {
            long s;
            long val = this.priorVal;
            int shift = 0;
            while (true) {
                if ((s = (long)PackedOffsets.this.data[this.index++]) >= 0L) break;
                val += -1L - s << shift;
                shift += 15;
            }
            this.priorVal = val += s << shift;
            return val;
        }
    }
}

