/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import java.util.Properties;

public class EnvironmentConfig
extends EnvironmentMutableConfig {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    public static final String MAX_MEMORY = "je.maxMemory";
    public static final String MAX_MEMORY_PERCENT = "je.maxMemoryPercent";
    public static final String SHARED_CACHE = "je.sharedCache";
    public static final String ENV_RECOVERY_FORCE_CHECKPOINT = "je.env.recoveryForceCheckpoint";
    public static final String ENV_RUN_IN_COMPRESSOR = "je.env.runINCompressor";
    public static final String ENV_RUN_CHECKPOINTER = "je.env.runCheckpointer";
    public static final String ENV_RUN_CLEANER = "je.env.runCleaner";
    public static final String ENV_BACKGROUND_READ_LIMIT = "je.env.backgroundReadLimit";
    public static final String ENV_BACKGROUND_WRITE_LIMIT = "je.env.backgroundWriteLimit";
    public static final String ENV_LOCKOUT_TIMEOUT = "je.env.lockoutTimeout";
    public static final String ENV_BACKGROUND_SLEEP_INTERVAL = "je.env.backgroundSleepInterval";
    public static final String ENV_CHECK_LEAKS = "je.env.checkLeaks";
    public static final String ENV_FORCED_YIELD = "je.env.forcedYield";
    public static final String ENV_IS_TRANSACTIONAL = "je.env.isTransactional";
    public static final String ENV_IS_LOCKING = "je.env.isLocking";
    public static final String ENV_READ_ONLY = "je.env.isReadOnly";
    public static final String ENV_FAIR_LATCHES = "je.env.fairLatches";
    public static final String ENV_DB_EVICTION = "je.env.dbEviction";
    public static final String ADLER32_CHUNK_SIZE = "je.adler32.chunkSize";
    public static final String LOG_TOTAL_BUFFER_BYTES = "je.log.totalBufferBytes";
    public static final String LOG_NUM_BUFFERS = "je.log.numBuffers";
    public static final String LOG_BUFFER_SIZE = "je.log.bufferSize";
    public static final String LOG_FAULT_READ_SIZE = "je.log.faultReadSize";
    public static final String LOG_ITERATOR_READ_SIZE = "je.log.iteratorReadSize";
    public static final String LOG_ITERATOR_MAX_SIZE = "je.log.iteratorMaxSize";
    public static final String LOG_FILE_MAX = "je.log.fileMax";
    public static final String LOG_CHECKSUM_READ = "je.log.checksumRead";
    public static final String LOG_VERIFY_CHECKSUMS = "je.log.verifyChecksums";
    public static final String LOG_MEM_ONLY = "je.log.memOnly";
    public static final String LOG_FILE_CACHE_SIZE = "je.log.fileCacheSize";
    public static final String LOG_FSYNC_TIMEOUT = "je.log.fsyncTimeout";
    public static final String LOG_USE_ODSYNC = "je.log.useODSYNC";
    public static final String LOG_USE_NIO = "je.log.useNIO";
    public static final String LOG_DIRECT_NIO = "je.log.directNIO";
    public static final String LOG_CHUNKED_NIO = "je.log.chunkedNIO";
    public static final String NODE_MAX_ENTRIES = "je.nodeMaxEntries";
    public static final String NODE_DUP_TREE_MAX_ENTRIES = "je.nodeDupTreeMaxEntries";
    public static final String TREE_MAX_DELTA = "je.tree.maxDelta";
    public static final String TREE_BIN_DELTA = "je.tree.binDelta";
    public static final String TREE_MIN_MEMORY = "je.tree.minMemory";
    public static final String COMPRESSOR_WAKEUP_INTERVAL = "je.compressor.wakeupInterval";
    public static final String COMPRESSOR_DEADLOCK_RETRY = "je.compressor.deadlockRetry";
    public static final String COMPRESSOR_LOCK_TIMEOUT = "je.compressor.lockTimeout";
    public static final String COMPRESSOR_PURGE_ROOT = "je.compressor.purgeRoot";
    public static final String EVICTOR_EVICT_BYTES = "je.evictor.evictBytes";
    public static final String EVICTOR_NODES_PER_SCAN = "je.evictor.nodesPerScan";
    public static final String EVICTOR_DEADLOCK_RETRY = "je.evictor.deadlockRetry";
    public static final String EVICTOR_LRU_ONLY = "je.evictor.lruOnly";
    public static final String EVICTOR_FORCED_YIELD = "je.evictor.forcedYield";
    public static final String CHECKPOINTER_BYTES_INTERVAL = "je.checkpointer.bytesInterval";
    public static final String CHECKPOINTER_WAKEUP_INTERVAL = "je.checkpointer.wakeupInterval";
    public static final String CHECKPOINTER_DEADLOCK_RETRY = "je.checkpointer.deadlockRetry";
    public static final String CHECKPOINTER_HIGH_PRIORITY = "je.checkpointer.highPriority";
    public static final String CLEANER_MIN_UTILIZATION = "je.cleaner.minUtilization";
    public static final String CLEANER_MIN_FILE_UTILIZATION = "je.cleaner.minFileUtilization";
    public static final String CLEANER_BYTES_INTERVAL = "je.cleaner.bytesInterval";
    public static final String CLEANER_FETCH_OBSOLETE_SIZE = "je.cleaner.fetchObsoleteSize";
    public static final String CLEANER_DEADLOCK_RETRY = "je.cleaner.deadlockRetry";
    public static final String CLEANER_LOCK_TIMEOUT = "je.cleaner.lockTimeout";
    public static final String CLEANER_EXPUNGE = "je.cleaner.expunge";
    public static final String CLEANER_MIN_AGE = "je.cleaner.minAge";
    public static final String CLEANER_MAX_BATCH_FILES = "je.cleaner.maxBatchFiles";
    public static final String CLEANER_READ_SIZE = "je.cleaner.readSize";
    public static final String CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE = "je.cleaner.detailMaxMemoryPercentage";
    public static final String CLEANER_FORCE_CLEAN_FILES = "je.cleaner.forceCleanFiles";
    public static final String CLEANER_UPGRADE_TO_LOG_VERSION = "je.cleaner.upgradeToLogVersion";
    public static final String CLEANER_THREADS = "je.cleaner.threads";
    public static final String CLEANER_LOOK_AHEAD_CACHE_SIZE = "je.cleaner.lookAheadCacheSize";
    public static final String LOCK_N_LOCK_TABLES = "je.lock.nLockTables";
    public static final String LOCK_TIMEOUT = "je.lock.timeout";
    public static final String TXN_TIMEOUT = "je.txn.timeout";
    public static final String TXN_SERIALIZABLE_ISOLATION = "je.txn.serializableIsolation";
    public static final String TXN_DEADLOCK_STACK_TRACE = "je.txn.deadlockStackTrace";
    public static final String TXN_DUMP_LOCKS = "je.txn.dumpLocks";
    public static final String TRACE_FILE = "java.util.logging.FileHandler.on";
    public static final String TRACE_CONSOLE = "java.util.logging.ConsoleHandler.on";
    public static final String TRACE_DB = "java.util.logging.DbLogHandler.on";
    public static final String TRACE_FILE_LIMIT = "java.util.logging.FileHandler.limit";
    public static final String TRACE_FILE_COUNT = "java.util.logging.FileHandler.count";
    public static final String TRACE_LEVEL = "java.util.logging.level";
    public static final String TRACE_LEVEL_LOCK_MANAGER = "java.util.logging.level.lockMgr";
    public static final String TRACE_LEVEL_RECOVERY = "java.util.logging.level.recovery";
    public static final String TRACE_LEVEL_EVICTOR = "java.util.logging.level.evictor";
    public static final String TRACE_LEVEL_CLEANER = "java.util.logging.level.cleaner";
    private boolean createUP = true;
    private boolean checkpointUP = true;
    private boolean allowCreate = false;
    private boolean txnReadCommitted = false;

    public EnvironmentConfig() {
    }

    public EnvironmentConfig(Properties properties) throws IllegalArgumentException {
        super(properties);
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setLockTimeout(long timeout) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.LOCK_TIMEOUT, Long.toString(timeout), this.validateParams);
    }

    public long getLockTimeout() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.LOCK_TIMEOUT);
        long timeout = 0L;
        try {
            timeout = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad value for timeout:" + e.getMessage());
        }
        return timeout;
    }

    public void setReadOnly(boolean readOnly) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_RDONLY, Boolean.toString(readOnly), this.validateParams);
    }

    public boolean getReadOnly() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_RDONLY);
        return Boolean.valueOf(val);
    }

    public void setTransactional(boolean transactional) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_INIT_TXN, Boolean.toString(transactional), this.validateParams);
    }

    public boolean getTransactional() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_INIT_TXN);
        return Boolean.valueOf(val);
    }

    public void setLocking(boolean locking) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_INIT_LOCKING, Boolean.toString(locking), this.validateParams);
    }

    public boolean getLocking() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_INIT_LOCKING);
        return Boolean.valueOf(val);
    }

    public void setTxnTimeout(long timeout) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.TXN_TIMEOUT, Long.toString(timeout), this.validateParams);
    }

    public long getTxnTimeout() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.TXN_TIMEOUT);
        long timeout = 0L;
        try {
            timeout = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad value for timeout:" + e.getMessage());
        }
        return timeout;
    }

    public void setTxnSerializableIsolation(boolean txnSerializableIsolation) {
        DbConfigManager.setVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION, Boolean.toString(txnSerializableIsolation), this.validateParams);
    }

    public boolean getTxnSerializableIsolation() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION);
        return Boolean.valueOf(val);
    }

    void setTxnReadCommitted(boolean txnReadCommitted) {
        this.txnReadCommitted = txnReadCommitted;
    }

    boolean getTxnReadCommitted() {
        return this.txnReadCommitted;
    }

    public void setSharedCache(boolean sharedCache) {
        DbConfigManager.setVal(this.props, EnvironmentParams.ENV_SHARED_CACHE, Boolean.toString(sharedCache), this.validateParams);
    }

    public boolean getSharedCache() {
        String val = DbConfigManager.getVal(this.props, EnvironmentParams.ENV_SHARED_CACHE);
        return Boolean.valueOf(val);
    }

    @Override
    public void setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, false, true);
    }

    void setCreateUP(boolean createUP) {
        this.createUP = createUP;
    }

    boolean getCreateUP() {
        return this.createUP;
    }

    void setCheckpointUP(boolean checkpointUP) {
        this.checkpointUP = checkpointUP;
    }

    boolean getCheckpointUP() {
        return this.checkpointUP;
    }

    EnvironmentConfig cloneConfig() {
        try {
            return (EnvironmentConfig)this.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "allowCreate=" + this.allowCreate + "\n" + super.toString();
    }
}

