/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

public class Durability {
    private final SyncPolicy localSync;
    private final SyncPolicy replicaSync;
    private final ReplicaAckPolicy replicaAck;

    public Durability(SyncPolicy localSync, SyncPolicy replicaSync, ReplicaAckPolicy replicaAck) {
        this.localSync = localSync;
        this.replicaSync = replicaSync;
        this.replicaAck = replicaAck;
    }

    public SyncPolicy getLocalSync() {
        return this.localSync;
    }

    public SyncPolicy getReplicaSync() {
        return this.replicaSync;
    }

    public ReplicaAckPolicy getReplicaAck() {
        return this.replicaAck;
    }

    public static final class ReplicaAckPolicy
    extends Enum<ReplicaAckPolicy> {
        public static final /* enum */ ReplicaAckPolicy ALL = new ReplicaAckPolicy();
        public static final /* enum */ ReplicaAckPolicy NONE = new ReplicaAckPolicy();
        public static final /* enum */ ReplicaAckPolicy QUORUM = new ReplicaAckPolicy();
        private static final /* synthetic */ ReplicaAckPolicy[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ReplicaAckPolicy[]{ALL, NONE, QUORUM};
        }

        public int requiredNodes(int groupSize) {
            switch (this) {
                case ALL: {
                    return groupSize;
                }
                case NONE: {
                    return 1;
                }
                case QUORUM: {
                    return groupSize <= 2 ? 1 : groupSize / 2 + 1;
                }
            }
            assert (false) : "unreachable";
            return Integer.MAX_VALUE;
        }

        public static ReplicaAckPolicy[] values() {
            ReplicaAckPolicy[] replicaAckPolicyArray = ENUM$VALUES;
            int n = replicaAckPolicyArray.length;
            ReplicaAckPolicy[] replicaAckPolicyArray2 = new ReplicaAckPolicy[n];
            System.arraycopy(ENUM$VALUES, 0, replicaAckPolicyArray2, 0, n);
            return replicaAckPolicyArray2;
        }

        public static ReplicaAckPolicy valueOf(String string) {
            return Enum.valueOf(ReplicaAckPolicy.class, string);
        }
    }

    public static enum SyncPolicy {
        SYNC,
        NO_SYNC,
        WRITE_NO_SYNC;

    }
}

