/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.MarshalledTupleEntry;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.util.RuntimeExceptionWrapper;

public class TupleMarshalledBinding<E extends MarshalledTupleEntry>
extends TupleBinding<E> {
    private Class<E> cls;

    public TupleMarshalledBinding(Class<E> cls) {
        this.cls = cls;
        if (!MarshalledTupleEntry.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(String.valueOf(cls.toString()) + " does not implement MarshalledTupleEntry");
        }
    }

    @Override
    public E entryToObject(TupleInput input) {
        try {
            MarshalledTupleEntry obj = (MarshalledTupleEntry)this.cls.newInstance();
            obj.unmarshalEntry(input);
            return (E)obj;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    @Override
    public void objectToEntry(E object, TupleOutput output) {
        object.marshalEntry(output);
    }
}

