/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.stream;

import com.lenovo.vctl.dal.cache.memcached.stream.LineInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public final class ByteBufArrayInputStream
extends InputStream
implements LineInputStream {
    private ByteBuffer[] bufs;
    private int currentBuf = 0;

    public ByteBufArrayInputStream(List<ByteBuffer> bufs) throws Exception {
        this(bufs.toArray(new ByteBuffer[0]));
    }

    public ByteBufArrayInputStream(ByteBuffer[] bufs) throws Exception {
        if (bufs == null || bufs.length == 0) {
            throw new Exception("buffer is empty");
        }
        this.bufs = bufs;
        ByteBuffer[] byteBufferArray = bufs;
        int n = bufs.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer b = byteBufferArray[n2];
            b.flip();
            ++n2;
        }
    }

    @Override
    public int read() {
        do {
            if (this.bufs[this.currentBuf].hasRemaining()) {
                return this.bufs[this.currentBuf].get();
            }
            ++this.currentBuf;
        } while (this.currentBuf < this.bufs.length);
        --this.currentBuf;
        return -1;
    }

    @Override
    public int read(byte[] buf) {
        int len = buf.length;
        int bufPos = 0;
        do {
            if (this.bufs[this.currentBuf].hasRemaining()) {
                int n = Math.min(this.bufs[this.currentBuf].remaining(), len - bufPos);
                this.bufs[this.currentBuf].get(buf, bufPos, n);
                bufPos += n;
            }
            ++this.currentBuf;
        } while (this.currentBuf < this.bufs.length && bufPos < len);
        --this.currentBuf;
        if (bufPos > 0 || bufPos == 0 && len == 0) {
            return bufPos;
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        byte[] b = new byte[1];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean eol = false;
        while (this.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
            } else if (eol) {
                if (b[0] == 10) break;
                eol = false;
            }
            bos.write(b, 0, 1);
        }
        if (bos == null || bos.size() <= 0) {
            throw new IOException("++++ Stream appears to be dead, so closing it down");
        }
        return bos.toString().trim();
    }

    @Override
    public void clearEOL() throws IOException {
        byte[] b = new byte[1];
        boolean eol = false;
        while (this.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
                continue;
            }
            if (!eol) continue;
            if (b[0] == 10) break;
            eol = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufArrayIS: ");
        sb.append(this.bufs.length).append(" bufs of sizes: \n");
        int i = 0;
        while (i < this.bufs.length) {
            sb.append("                                        ").append(i).append(":  ").append(this.bufs[i]).append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void clearEnd() throws IOException {
    }

    @Override
    public String readKeys(String keys) throws IOException {
        return null;
    }
}

