/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.channel.source;

import com.lenovo.vctl.dal.cache.memcached.channel.MemcachedChannel;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import com.lenovo.vctl.dal.cache.route.ContextHolder;
import java.util.Map;
import org.apache.log4j.Logger;

public class RoutingMemcachedSource
implements MemcachedSource {
    private static Logger logger = Logger.getLogger(RoutingMemcachedSource.class);
    private Map<String, MemcachedSource> resolvedMemcachedSources = null;
    private MemcachedSource resolvedDefaultMemcachedSource;

    @Override
    public MemcachedChannel getMemcachedChannel() throws Exception {
        return this.determineTargetMemcachedSource().getMemcachedChannel();
    }

    public void setResolvedMemcachedSources(Map<String, MemcachedSource> resolvedMemcachedSources) {
        this.resolvedMemcachedSources = resolvedMemcachedSources;
    }

    protected MemcachedSource determineTargetMemcachedSource() {
        if (this.resolvedMemcachedSources == null) {
            throw new RuntimeException("MemcachedSource router not initialized");
        }
        Object lookupKey = this.determineCurrentLookupKey();
        MemcachedSource memcachedSource = this.resolvedMemcachedSources.get(lookupKey);
        if (memcachedSource == null) {
            memcachedSource = this.resolvedDefaultMemcachedSource;
        }
        if (memcachedSource == null) {
            throw new IllegalStateException("Cannot determine target memcachedSource for lookup key [" + lookupKey + "]");
        }
        return memcachedSource;
    }

    protected Object determineCurrentLookupKey() {
        Object memcachedName = ContextHolder.getMemcachedName();
        return memcachedName;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

