/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.memcached.channel.source;

import com.lenovo.vctl.dal.cache.memcached.channel.MemcachedChannel;
import com.lenovo.vctl.dal.cache.memcached.channel.pool.MChannelFactoryImpl;
import com.lenovo.vctl.dal.cache.memcached.channel.pool.MChannellPoolableObjectFactory;
import com.lenovo.vctl.dal.cache.memcached.channel.source.MemcachedSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class MemcachedSourceImpl
implements MemcachedSource {
    private static Logger logger = Logger.getLogger(MemcachedSourceImpl.class);
    protected int maxActive = 8;
    protected int maxIdle = 28;
    protected int minIdle = 0;
    protected long maxWait = 1000L;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean testWhileIdle = false;
    private String host;
    private int port;
    private int timeout;
    private boolean isCreatePool = false;
    private GenericObjectPool mChannelPool;

    public MemcachedSourceImpl(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    @Override
    public MemcachedChannel getMemcachedChannel() throws Exception {
        if (!this.isCreatePool) {
            this.createPool();
        }
        return (MemcachedChannel)this.mChannelPool.borrowObject();
    }

    private synchronized void createPool() throws Exception {
        if (this.isCreatePool) {
            return;
        }
        this.mChannelPool = new GenericObjectPool();
        this.mChannelPool.setMaxActive(this.maxActive);
        this.mChannelPool.setMaxIdle(this.maxIdle);
        this.mChannelPool.setMinIdle(this.minIdle);
        this.mChannelPool.setMaxWait(this.maxWait);
        this.mChannelPool.setTestOnBorrow(this.testOnBorrow);
        this.mChannelPool.setTestOnReturn(this.testOnReturn);
        this.mChannelPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.mChannelPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        this.mChannelPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.mChannelPool.setTestWhileIdle(this.testWhileIdle);
        this.mChannelPool.setWhenExhaustedAction((byte)1);
        MChannellPoolableObjectFactory channellPoolableObjectFactory = new MChannellPoolableObjectFactory(new MChannelFactoryImpl(this.host, this.port, this.timeout), (ObjectPool)this.mChannelPool);
        MemcachedSourceImpl.validateMChannellFactory(channellPoolableObjectFactory);
        this.isCreatePool = true;
    }

    private static void validateMChannellFactory(MChannellPoolableObjectFactory factory) throws Exception {
        MemcachedChannel mChannel = null;
        try {
            mChannel = (MemcachedChannel)factory.makeObject();
            factory.activateObject(mChannel);
            factory.validateObject(mChannel);
            factory.passivateObject(mChannel);
        }
        finally {
            factory.destroyObject(mChannel);
        }
    }

    public synchronized void close() throws Exception {
        GenericObjectPool oldpool = this.mChannelPool;
        this.mChannelPool = null;
        try {
            if (oldpool != null) {
                oldpool.close();
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot close memcached connection pool", e);
        }
        logger.info((Object)"close pool completed");
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MemcachedSourceImpl[");
        buffer.append("host = ").append(this.host);
        buffer.append(" port = ").append(this.port);
        buffer.append(" timeout = ").append(this.timeout);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

