/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.impl;

import com.lenovo.vctl.dal.cache.Cache;
import com.lenovo.vctl.dal.cache.CacheUtil;
import com.lenovo.vctl.dal.cache.ListResult;
import com.lenovo.vctl.dal.cache.LocalCacheFactory;
import com.lenovo.vctl.dal.cache.binding.BindingHelper;
import com.lenovo.vctl.dal.cache.client.CacheClient;
import com.lenovo.vctl.dal.cache.exception.CacheException;
import com.lenovo.vctl.dal.cache.exception.NotFoundKeyException;
import com.lenovo.vctl.dal.cache.impl.MultiThreadGet;
import com.lenovo.vctl.dal.cache.listener.Listener;
import com.lenovo.vctl.dal.cache.route.ContextHolder;
import com.lenovo.vctl.dal.cache.route.RoutingService;
import com.lenovo.vctl.dal.cache.utils.DebugTimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CacheImpl
implements Cache {
    private static Logger logger = Logger.getLogger(CacheImpl.class);
    private String regionName;
    private CacheClient client;
    private boolean hasRoute = false;
    private RoutingService routingService;
    private Listener listener;
    private boolean enableLocalCache = false;
    private boolean enableDelMark = false;
    private Map<String, Object> delMarkMap = Collections.synchronizedMap(new LRUMap(5000));
    private Cache localCache;
    private boolean hasClassInfo = true;
    private static final byte DELETE_BYTE = 49;
    private int limitLen = 300;
    private int initLen = 100;

    public int getLimitLen() {
        return this.limitLen;
    }

    public void setLimitLen(int limitLen) {
        this.limitLen = limitLen;
    }

    public int getInitLen() {
        return this.initLen;
    }

    public void setInitLen(int initLen) {
        this.initLen = initLen;
    }

    public boolean isHasClassInfo() {
        return this.hasClassInfo;
    }

    public void setHasClassInfo(boolean hasClassInfo) {
        this.hasClassInfo = hasClassInfo;
    }

    public CacheImpl() {
    }

    public CacheImpl(String region, CacheClient client, RoutingService routingService) {
        this.client = client;
        this.regionName = region;
        this.hasRoute = client.isDynamic();
        this.routingService = routingService;
        if (this.hasRoute && this.routingService == null) {
            throw new RuntimeException("Must set RoutingService, because CacheClient is Dynamic CacheClient!");
        }
        if (StringUtils.isEmpty((String)this.regionName)) {
            throw new RuntimeException("region name must have value!");
        }
    }

    @Override
    public boolean delete(String key) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return false;
        }
        boolean b = false;
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
        this.exeBeforeListener(key, null, "delete");
        if (this.enableLocalCache) {
            this.getLocalCache().delete(key);
            if (this.enableDelMark) {
                this.getLocalCache().put(sDelMarkKey, Boolean.TRUE);
            }
        }
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            b = this.client.delete(sTempKey);
            if (this.enableDelMark) {
                if (this.isHasClassInfo()) {
                    this.client.set(sDelMarkKey, Boolean.TRUE);
                } else {
                    this.client.set(sDelMarkKey, (byte)49);
                }
            }
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, null, "delete");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete time : " + DebugTimeUtils.getDistanceTime()));
        }
        return b;
    }

    @Override
    public boolean remove(String key) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return false;
        }
        boolean b = false;
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        this.exeBeforeListener(key, null, "remove");
        if (this.enableLocalCache) {
            this.getLocalCache().remove(key);
        }
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            b = this.client.remove(sTempKey);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, null, "remove");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete time : " + DebugTimeUtils.getDistanceTime()));
        }
        return b;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object get(String key) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            CacheImpl.logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return null;
        }
        o = null;
        this.exeBeforeListener(key, null, "get");
        sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
        if (this.enableLocalCache) {
            o = this.getLocalCache().get(key);
            if (this.enableDelMark && o != null && (b = (Boolean)this.getLocalCache().get(sDelMarkKey)) != null && b.booleanValue()) {
                this.putDelKey(key);
                this.getLocalCache().delete(key);
                return null;
            }
        }
        if (o == null) {
            sTempKey = CacheUtil.keyEncode(this.regionName, key);
            try {
                if (this.hasRoute) {
                    this.routingService.setRoutingStrategy(this.regionName, key);
                }
                if (this.enableDelMark) {
                    keys = new String[]{sTempKey, sDelMarkKey};
                    rets = this.client.getMultiArray(keys);
                    if (!ArrayUtils.isEmpty((Object[])rets)) {
                        if (rets.length > 1 && rets[1] != null) {
                            this.putDelKey(key);
                            if (this.enableLocalCache && this.enableDelMark) {
                                this.getLocalCache().put(sDelMarkKey, Boolean.TRUE);
                            }
                            o = null;
                        } else {
                            o = rets[0];
                        }
                    }
                } else {
                    o = this.client.get(sTempKey);
                }
                if (o != null && !this.isHasClassInfo()) {
                    o = BindingHelper.getObjectFromByte((byte[])o, this.regionName);
                }
                if (!this.enableLocalCache || o == null) ** GOTO lbl45
                this.getLocalCache().put(key, o);
            }
            catch (Exception e) {
                throw new CacheException(e);
            }
        } else if (CacheImpl.logger.isDebugEnabled()) {
            CacheImpl.logger.info((Object)"location cache have value");
        }
lbl45:
        // 5 sources

        this.exeAfterListener(key, o, "get");
        if (CacheImpl.logger.isDebugEnabled()) {
            CacheImpl.logger.debug((Object)("get time : " + DebugTimeUtils.getDistanceTime()));
        }
        return o;
    }

    @Override
    public boolean put(String key, Object value) throws CacheException {
        return this.put(key, value, key);
    }

    @Override
    public boolean put(String key, Object value, String dispatchKey) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "put");
        if (this.enableLocalCache) {
            this.getLocalCache().put(key, value);
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, dispatchKey);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            bResult = this.client.set(sTempKey, mValue);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "put");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    @Override
    public boolean update(String key, Object value) throws CacheException {
        DebugTimeUtils.begTime();
        boolean b = false;
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        this.exeBeforeListener(key, value, "update");
        if (this.enableLocalCache) {
            this.getLocalCache().update(key, value);
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            b = this.client.set(sTempKey, mValue);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "update");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return b;
    }

    @Override
    public String getRegion() throws CacheException {
        return this.regionName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public CacheClient getClient() {
        return this.client;
    }

    public void setClient(CacheClient client) {
        this.client = client;
    }

    public boolean isHasRoute() {
        return this.hasRoute;
    }

    public void setHasRoute(boolean hasRoute) {
        this.hasRoute = hasRoute;
    }

    public RoutingService getRoutingService() {
        return this.routingService;
    }

    public void setRoutingService(RoutingService routingService) {
        this.routingService = routingService;
    }

    @Override
    public void regListener(Listener listener) {
        this.listener = listener;
    }

    private Cache getLocalCache() {
        if (this.localCache == null) {
            this.localCache = LocalCacheFactory.getInstance().getCache(this.regionName);
        }
        return this.localCache;
    }

    private void exeBeforeListener(Object key, Object value, String operateMethod) {
        if (this.listener != null) {
            this.listener.beforeListener((Cache)this, key, value, operateMethod);
        }
    }

    private void exeAfterListener(Object key, Object value, String operateMethod) {
        if (this.listener != null) {
            this.listener.afterListener((Cache)this, key, value, operateMethod);
        }
    }

    private void exeBeforeListener(Object[] keys, Object[] values, String operateMethod) {
        if (this.listener != null) {
            this.listener.beforeListener((Cache)this, keys, values, operateMethod);
        }
    }

    private void exeAfterListener(Object[] keys, Object[] values, String operateMethod) {
        if (this.listener != null) {
            this.listener.afterListener((Cache)this, keys, values, operateMethod);
        }
    }

    @Override
    public boolean save(String key, Object value) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return false;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "put");
        if (this.enableLocalCache) {
            this.getLocalCache().save(key, value);
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            Object mValue = this.isHasClassInfo() ? value : (Object)BindingHelper.getByteFromObject(value);
            bResult = this.client.set(sTempKey, mValue);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, value, "put");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    private void putDelKey(String key) {
        if (!this.delMarkMap.containsKey(key)) {
            this.delMarkMap.put(key, Boolean.TRUE);
        }
    }

    @Override
    public boolean isDelete(String key) throws CacheException {
        if (this.enableDelMark) {
            return this.delMarkMap.containsKey(key);
        }
        return false;
    }

    public void setEnableLocalCache(boolean enableLocalCache) {
        this.enableLocalCache = enableLocalCache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object[] get(String[] keys) throws CacheException {
        void var6_15;
        DebugTimeUtils.begTime();
        if (ArrayUtils.isEmpty((Object[])keys)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " keys is empty or null"));
            return null;
        }
        this.exeBeforeListener(keys, null, "get");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> memCacheKeys = new ArrayList<String>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (key != null) {
                if (this.enableLocalCache) {
                    Object object = this.getLocalCache().get(key);
                    if (this.enableDelMark) {
                        String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
                        Boolean b = (Boolean)this.getLocalCache().get(sDelMarkKey);
                        if (b != null && b.booleanValue()) {
                            this.putDelKey(key);
                        }
                    }
                    if (object != null) {
                        resultMap.put(key, object);
                    } else {
                        memCacheKeys.add(key);
                    }
                } else {
                    memCacheKeys.add(key);
                }
            }
            ++i;
        }
        if (memCacheKeys.size() > 0) {
            List sourceKeys;
            HashMap sourceMap = new HashMap();
            HashMap delMarkSourceMap = new HashMap();
            for (String string : memCacheKeys) {
                String cacheName;
                if (this.hasRoute) {
                    try {
                        this.routingService.setRoutingStrategy(this.regionName, string);
                    }
                    catch (Exception e) {
                        throw new CacheException(e);
                    }
                }
                if ((sourceKeys = (ArrayList<String>)sourceMap.get(cacheName = ObjectUtils.toString((Object)ContextHolder.getMemcachedName(), (String)"null"))) == null) {
                    sourceKeys = new ArrayList<String>();
                    sourceMap.put(cacheName, sourceKeys);
                }
                String sTempKey = CacheUtil.keyEncode(this.regionName, string);
                sourceKeys.add(sTempKey);
                if (!this.enableDelMark) continue;
                ArrayList<String> sourceDelMarkKeys = (ArrayList<String>)delMarkSourceMap.get(cacheName);
                if (sourceDelMarkKeys == null) {
                    sourceDelMarkKeys = new ArrayList<String>();
                    delMarkSourceMap.put(cacheName, sourceDelMarkKeys);
                }
                String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, string);
                sourceDelMarkKeys.add(sDelMarkKey);
            }
            for (Map.Entry entry : sourceMap.entrySet()) {
                List sourceDelMarkKeys;
                String sourceName = (String)entry.getKey();
                ContextHolder.setCachdName("null".equals(sourceName) ? null : sourceName);
                sourceKeys = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty(sourceKeys)) continue;
                String[] a = new String[sourceKeys.size()];
                a = sourceKeys.toArray(a);
                Object[] oResults = MultiThreadGet.get(this.client, a, ObjectUtils.toString((Object)ContextHolder.getMemcachedName(), null));
                int i2 = 0;
                while (i2 < oResults.length) {
                    Object o = oResults[i2];
                    String key = CacheUtil.keyDecode(this.regionName, a[i2]);
                    if (o != null && key != null) {
                        Object mValue;
                        Object object = mValue = this.isHasClassInfo() ? o : BindingHelper.getObjectFromByte((byte[])o, this.regionName);
                        if (this.enableLocalCache) {
                            this.getLocalCache().put(key, mValue);
                        }
                        resultMap.put(key, mValue);
                    }
                    ++i2;
                }
                if (!this.enableDelMark || !CollectionUtils.isNotEmpty((Collection)(sourceDelMarkKeys = (List)delMarkSourceMap.get(sourceName)))) continue;
                String[] a2 = new String[sourceDelMarkKeys.size()];
                a2 = sourceDelMarkKeys.toArray(a2);
                Object[] oResults2 = this.client.getMultiArray(a2);
                int i3 = 0;
                while (i3 < oResults2.length) {
                    Object o = oResults2[i3];
                    String key = a2[i3];
                    if (o != null && key != null) {
                        this.putDelKey(key);
                    }
                    ++i3;
                }
            }
        }
        Object[] lResult = new Object[keys.length];
        int size = keys.length;
        boolean bl = false;
        while (var6_15 < size) {
            String key = keys[var6_15];
            lResult[var6_15] = key == null ? null : resultMap.get(key);
            ++var6_15;
        }
        this.exeAfterListener(keys, lResult, "get");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("gets time : " + DebugTimeUtils.getDistanceTime()));
        }
        return lResult;
    }

    @Override
    public boolean save(Map<String, Object> objectsMap) throws CacheException {
        CacheException lastException = null;
        if (MapUtils.isNotEmpty(objectsMap)) {
            Set<Map.Entry<String, Object>> set = objectsMap.entrySet();
            Iterator<Map.Entry<String, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().getKey();
                Object o = iterator.next().getValue();
                if (o == null) continue;
                try {
                    this.save(key, o);
                }
                catch (CacheException e) {
                    lastException = e;
                    e.printStackTrace(System.err);
                }
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return true;
    }

    @Override
    public long decr(String key, long inc) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty"));
            throw new CacheException("key is must have value");
        }
        long bResult = -1L;
        this.exeBeforeListener(key, inc, "decr");
        if (this.enableLocalCache) {
            logger.warn((Object)"don't suport local cache in incr method");
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            bResult = this.client.decr(sTempKey, inc);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, inc, "decr");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("put time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    @Override
    public long incr(String key, long inc) throws CacheException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty"));
            throw new CacheException("key is must have value");
        }
        long bResult = -1L;
        this.exeBeforeListener(key, inc, "incr");
        if (this.enableLocalCache) {
            logger.warn((Object)"don't suport local cache in incr method");
        }
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            bResult = this.client.incr(sTempKey, inc);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        this.exeAfterListener(key, inc, "inc");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("decr time : " + DebugTimeUtils.getDistanceTime()));
        }
        return bResult;
    }

    @Override
    public ListResult ladd(String key, String value) throws NotFoundKeyException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return ListResult.LIST_ERROR;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "ladd");
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            if (!(bResult = this.client.prepend(sTempKey, String.valueOf(value) + ","))) {
                return ListResult.LIST_NOTEXIST;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.exeAfterListener(key, value, "ladd");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ladd time : " + DebugTimeUtils.getDistanceTime()));
        }
        return ListResult.LIST_OK;
    }

    @Override
    public List<String> lrange(String key, int beg, int end) throws NotFoundKeyException {
        ArrayList<Object> lResult = null;
        if (beg > end || end == 0) {
            return lResult;
        }
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return null;
        }
        Object o = null;
        this.exeBeforeListener(key, null, "lrange");
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            Object[] tempArray;
            String resultStr;
            Object[] strings;
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            if ((o = this.client.get(sTempKey)) != null && !ArrayUtils.isEmpty((Object[])(strings = StringUtils.split((String)(resultStr = (String)o), (char)','))) && !ArrayUtils.isEmpty((Object[])(tempArray = (String[])ArrayUtils.subarray((Object[])strings, (int)beg, (int)end)))) {
                lResult = new ArrayList<Object>();
                int i = 0;
                while (i < tempArray.length) {
                    lResult.add(tempArray[i]);
                    ++i;
                }
                if (tempArray.length > this.limitLen) {
                    logger.info((Object)"list too long , begin remove");
                    this.remove(key);
                }
            }
        }
        catch (Exception e) {
            throw new NotFoundKeyException(e);
        }
        this.exeAfterListener(key, o, "get");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get time : " + DebugTimeUtils.getDistanceTime()));
        }
        return lResult;
    }

    @Override
    public ListResult radd(String key, String value) throws NotFoundKeyException {
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key) || value == null) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or value is null"));
            return ListResult.LIST_ERROR;
        }
        boolean bResult = false;
        this.exeBeforeListener(key, value, "radd");
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            if (!(bResult = this.client.append(sTempKey, "," + value))) {
                return ListResult.LIST_NOTEXIST;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.exeAfterListener(key, value, "radd");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ladd time : " + DebugTimeUtils.getDistanceTime()));
        }
        return ListResult.LIST_OK;
    }

    @Override
    public ListResult removeList(String key) throws CacheException {
        if (this.remove(key)) {
            return ListResult.LIST_OK;
        }
        return ListResult.LIST_LIMT;
    }

    @Override
    public ListResult setList(String key, List<Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            if (values.size() > this.limitLen) {
                return ListResult.LIST_LIMT;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < values.size()) {
                Object value = values.get(i);
                if (sb.length() > 0) {
                    sb.append(",").append(ObjectUtils.toString((Object)value, (String)""));
                } else {
                    sb.append(ObjectUtils.toString((Object)value, (String)""));
                }
                ++i;
            }
            try {
                String sTempKey;
                if (this.hasRoute) {
                    this.routingService.setRoutingStrategy(this.regionName, key);
                }
                if (this.client.setList(sTempKey = CacheUtil.keyEncode(this.regionName, key), sb.toString())) {
                    return ListResult.LIST_OK;
                }
                return ListResult.LIST_ERROR;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.info((Object)"value list is empty or null");
        return ListResult.LIST_OK;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] gets(String[] keys) throws CacheException {
        void var6_15;
        DebugTimeUtils.begTime();
        if (ArrayUtils.isEmpty((Object[])keys)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " keys is empty or null"));
            return null;
        }
        this.exeBeforeListener(keys, null, "get");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> memCacheKeys = new ArrayList<String>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (key != null) {
                if (this.enableLocalCache) {
                    Object object = this.getLocalCache().get(key);
                    if (this.enableDelMark) {
                        String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, key);
                        Boolean b = (Boolean)this.getLocalCache().get(sDelMarkKey);
                        if (b != null && b.booleanValue()) {
                            this.putDelKey(key);
                        }
                    }
                    if (object != null) {
                        resultMap.put(key, object);
                    } else {
                        memCacheKeys.add(key);
                    }
                } else {
                    memCacheKeys.add(key);
                }
            }
            ++i;
        }
        if (memCacheKeys.size() > 0) {
            List sourceKeys;
            HashMap sourceMap = new HashMap();
            HashMap delMarkSourceMap = new HashMap();
            for (String string : memCacheKeys) {
                String cacheName;
                if (this.hasRoute) {
                    try {
                        this.routingService.setRoutingStrategy(this.regionName, string);
                    }
                    catch (Exception e) {
                        throw new CacheException(e);
                    }
                }
                if ((sourceKeys = (ArrayList<String>)sourceMap.get(cacheName = ObjectUtils.toString((Object)ContextHolder.getMemcachedName(), (String)"null"))) == null) {
                    sourceKeys = new ArrayList<String>();
                    sourceMap.put(cacheName, sourceKeys);
                }
                String sTempKey = CacheUtil.keyEncode(this.regionName, string);
                sourceKeys.add(sTempKey);
                if (!this.enableDelMark) continue;
                ArrayList<String> sourceDelMarkKeys = (ArrayList<String>)delMarkSourceMap.get(cacheName);
                if (sourceDelMarkKeys == null) {
                    sourceDelMarkKeys = new ArrayList<String>();
                    delMarkSourceMap.put(cacheName, sourceDelMarkKeys);
                }
                String sDelMarkKey = CacheUtil.delMarkKey(this.regionName, string);
                sourceDelMarkKeys.add(sDelMarkKey);
            }
            for (Map.Entry entry : sourceMap.entrySet()) {
                List sourceDelMarkKeys;
                String sourceName = (String)entry.getKey();
                ContextHolder.setCachdName("null".equals(sourceName) ? null : sourceName);
                sourceKeys = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty(sourceKeys)) continue;
                String[] a = new String[sourceKeys.size()];
                a = sourceKeys.toArray(a);
                Object[] oResults = this.client.getMultiArray(a);
                int i2 = 0;
                while (i2 < oResults.length) {
                    Object o = oResults[i2];
                    String key = CacheUtil.keyDecode(this.regionName, a[i2]);
                    if (o != null && key != null) {
                        Object mValue;
                        Object object = mValue = this.isHasClassInfo() ? o : BindingHelper.getObjectFromByte((byte[])o, this.regionName);
                        if (this.enableLocalCache) {
                            this.getLocalCache().put(key, mValue);
                        }
                        resultMap.put(key, mValue);
                    }
                    ++i2;
                }
                if (!this.enableDelMark || !CollectionUtils.isNotEmpty((Collection)(sourceDelMarkKeys = (List)delMarkSourceMap.get(sourceName)))) continue;
                String[] a2 = new String[sourceDelMarkKeys.size()];
                a2 = sourceDelMarkKeys.toArray(a2);
                Object[] oResults2 = this.client.getMultiArray(a2);
                int i3 = 0;
                while (i3 < oResults2.length) {
                    Object o = oResults2[i3];
                    String key = a2[i3];
                    if (o != null && key != null) {
                        this.putDelKey(key);
                    }
                    ++i3;
                }
            }
        }
        Object[] lResult = new Object[keys.length];
        int size = keys.length;
        boolean bl = false;
        while (var6_15 < size) {
            String key = keys[var6_15];
            lResult[var6_15] = key == null ? null : resultMap.get(key);
            ++var6_15;
        }
        this.exeAfterListener(keys, lResult, "get");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("gets time : " + DebugTimeUtils.getDistanceTime()));
        }
        return lResult;
    }

    @Override
    public Integer lsize(String key) throws CacheException {
        Integer iResult = -1;
        DebugTimeUtils.begTime();
        if (StringUtils.isEmpty((String)key)) {
            logger.info((Object)("region: " + StringUtils.defaultIfEmpty((String)this.regionName, (String)"") + " key is empty or null"));
            return null;
        }
        Object o = null;
        this.exeBeforeListener(key, null, "lrange");
        String sTempKey = CacheUtil.keyEncode(this.regionName, key);
        try {
            String resultStr;
            Object[] strings;
            if (this.hasRoute) {
                this.routingService.setRoutingStrategy(this.regionName, key);
            }
            if ((o = this.client.get(sTempKey)) != null && !ArrayUtils.isEmpty((Object[])(strings = StringUtils.split((String)(resultStr = (String)o), (char)',')))) {
                iResult = strings.length;
            }
        }
        catch (Exception e) {
            throw new NotFoundKeyException(e);
        }
        this.exeAfterListener(key, o, "get");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get time : " + DebugTimeUtils.getDistanceTime()));
        }
        return iResult;
    }
}

