/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.vctl.dal.cache.config.model;

import com.lenovo.vctl.dal.cache.config.model.KeyPatternItem;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RegionItem
implements Serializable {
    private static final long serialVersionUID = -2427500931734139981L;
    private static Logger logger = Logger.getLogger(RegionItem.class);
    private String name;
    private String listenerClass;
    private String strategyClass;
    private boolean hasClassInfo = true;
    private int limitLen = 300;
    private int initLen = 100;
    private Map<String, KeyPatternItem> keyPatternMap = new HashMap<String, KeyPatternItem>();
    private boolean localCache;
    private boolean remoteCache = true;

    public boolean isRemoteCache() {
        return this.remoteCache;
    }

    public void setRemoteCache(boolean remoteCache) {
        this.remoteCache = remoteCache;
    }

    public boolean isLocalCache() {
        return this.localCache;
    }

    public void setLocalCache(boolean localCache) {
        this.localCache = localCache;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(String listenerClass) {
        this.listenerClass = listenerClass;
    }

    public Map<String, KeyPatternItem> getKeyPatternMap() {
        return this.keyPatternMap;
    }

    public void addKeyPatternItem(KeyPatternItem item) {
        if (item != null && StringUtils.isNotEmpty((String)item.getValue())) {
            if (!this.keyPatternMap.containsKey(item.getValue())) {
                this.keyPatternMap.put(item.getValue(), item);
            } else {
                logger.error((Object)("region: " + StringUtils.defaultIfEmpty((String)this.name, (String)"") + " same patternitem <" + item.getValue() + "> exist!"));
            }
        } else {
            logger.error((Object)"KeyPatternItem object is null or value is null, please set in memcached_client.xml.");
        }
    }

    public void resetKeyPatternItems(List<KeyPatternItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        HashMap<String, KeyPatternItem> newKeyPs = new HashMap<String, KeyPatternItem>();
        for (KeyPatternItem item : items) {
            if (item != null && StringUtils.isNotEmpty((String)item.getValue())) {
                if (!newKeyPs.containsKey(item.getValue())) {
                    newKeyPs.put(item.getValue(), item);
                    continue;
                }
                logger.error((Object)("region: " + StringUtils.defaultIfEmpty((String)this.name, (String)"") + " same patternitem <" + item.getValue() + "> exist!"));
                continue;
            }
            logger.error((Object)"KeyPatternItem object is null or value is null, please set in memcached_client.xml.");
        }
        if (MapUtils.isNotEmpty(newKeyPs)) {
            this.keyPatternMap = newKeyPs;
        }
    }

    public String getStrategyClass() {
        return this.strategyClass;
    }

    public void setStrategyClass(String strategyClass) {
        this.strategyClass = strategyClass;
    }

    public boolean isHasClassInfo() {
        return this.hasClassInfo;
    }

    public void setHasClassInfo(boolean hasClassInfo) {
        this.hasClassInfo = hasClassInfo;
    }

    public int getLimitLen() {
        return this.limitLen;
    }

    public void setLimitLen(int limitLen) {
        this.limitLen = limitLen;
    }

    public int getInitLen() {
        return this.initLen;
    }

    public void setInitLen(int initLen) {
        this.initLen = initLen;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RegionItem[");
        buffer.append("hasClassInfo = ").append(this.hasClassInfo);
        buffer.append(",\n initLen = ").append(this.initLen);
        buffer.append(",\n keyPatternMap = ").append(this.keyPatternMap);
        buffer.append(",\n limitLen = ").append(this.limitLen);
        buffer.append(",\n listenerClass = ").append(this.listenerClass);
        buffer.append(",\n localCache = ").append(this.localCache);
        buffer.append(",\n name = ").append(this.name);
        buffer.append(",\n strategyClass = ").append(this.strategyClass);
        buffer.append("]");
        return buffer.toString();
    }
}

