/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class EclipseLaunchConfigMojo
extends AbstractMojo {
    protected MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if ("war".equals(this.mavenProject.getPackaging())) {
                this.copyFile("heroku-deploy-war.launch", "heroku:deploy-war");
                this.copyFile("heroku-run-war.launch", "heroku:run-war");
            } else {
                this.copyFile("heroku-deploy.launch", "heroku:deploy");
            }
            this.copyFile("heroku-dashboard.launch", "heroku:dashboard");
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not create launch configuration files!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String filename, String mavenGoal) throws IOException {
        this.getLog().info((CharSequence)("Generating " + filename + " configuration..."));
        BufferedWriter out = null;
        try {
            String line;
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/heroku-eclipse-base-config.launch");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            FileWriter fw = new FileWriter(filename);
            out = new BufferedWriter(fw);
            while ((line = br.readLine()) != null) {
                line = line.replace("%_MAVEN_GOAL_%", mavenGoal);
                line = line.replace("%_PROJECT_DIR_%", System.getProperty("user.dir"));
                out.write(line);
                out.write("\n");
            }
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }
}

