/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.CSSPropertyEnum;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSPropertyEnumOrNumber
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eCSSProperty, boolean bl, String ... stringArray) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, bl, stringArray);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, String ... stringArray) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, bl, stringArray);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, String ... stringArray) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, stringArray);
        this.m_bWithPercentage = bl;
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, bl, iterable);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnull @Nonempty Iterable<String> iterable) {
        this(eCSSProperty, (ECSSVendorPrefix)null, iCSSPropertyCustomizer, bl, iterable);
    }

    public CSSPropertyEnumOrNumber(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer, iterable);
        this.m_bWithPercentage = bl;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        return super.isValidValue(string) || CSSNumberHelper.isValueWithUnit(string, this.m_bWithPercentage);
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumber getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnumOrNumber(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage, this.directGetEnumValues());
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumber getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyEnumOrNumber(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_bWithPercentage, this.directGetEnumValues());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyEnumOrNumber cSSPropertyEnumOrNumber = (CSSPropertyEnumOrNumber)object;
        return this.m_bWithPercentage == cSSPropertyEnumOrNumber.m_bWithPercentage;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).toString();
    }
}

