/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.RelativeUnixPath;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class JavaContainerBuilderHelper {
    public static LayerConfiguration extraDirectoryLayerConfiguration(Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions) throws IOException {
        LayerConfiguration.Builder builder = LayerConfiguration.builder().setName(JavaContainerBuilder.LayerType.EXTRA_FILES.getName());
        new DirectoryWalker(extraDirectory).filterRoot().walk(localPath -> {
            AbsoluteUnixPath pathOnContainer = AbsoluteUnixPath.get("/").resolve(extraDirectory.relativize(localPath));
            FilePermissions permissions = (FilePermissions)extraDirectoryPermissions.get(pathOnContainer);
            if (permissions == null) {
                builder.addEntry(localPath, pathOnContainer);
            } else {
                builder.addEntry(localPath, pathOnContainer, permissions);
            }
        });
        return builder.build();
    }

    public static JibContainerBuilder fromExplodedWar(JavaContainerBuilder javaContainerBuilder, Path explodedWar) throws IOException {
        Path webInfLib = explodedWar.resolve("WEB-INF/lib");
        Path webInfClasses = explodedWar.resolve("WEB-INF/classes");
        Predicate<Path> isDependency = path -> path.startsWith(webInfLib);
        Predicate<Path> isClassFile = path -> path.startsWith(webInfClasses) && path.getFileName().toString().endsWith(".class");
        Predicate<Path> isResource = isDependency.or(isClassFile).negate();
        javaContainerBuilder.setResourcesDestination(RelativeUnixPath.get("")).setClassesDestination(RelativeUnixPath.get("WEB-INF/classes")).setDependenciesDestination(RelativeUnixPath.get("WEB-INF/lib"));
        if (Files.exists(explodedWar, new LinkOption[0])) {
            javaContainerBuilder.addResources(explodedWar, isResource);
        }
        if (Files.exists(webInfClasses, new LinkOption[0])) {
            javaContainerBuilder.addClasses(webInfClasses, isClassFile);
        }
        if (Files.exists(webInfLib, new LinkOption[0])) {
            javaContainerBuilder.addDependencies((List<Path>)new DirectoryWalker(webInfLib).filterRoot().filter(path -> !path.getFileName().toString().contains("SNAPSHOT")).walk());
            javaContainerBuilder.addSnapshotDependencies((List<Path>)new DirectoryWalker(webInfLib).filterRoot().filter(path -> path.getFileName().toString().contains("SNAPSHOT")).walk());
        }
        return javaContainerBuilder.toContainerBuilder();
    }

    private JavaContainerBuilderHelper() {
    }
}

