/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.events.TimerEvent;
import com.google.cloud.tools.jib.event.progress.ProgressEventHandler;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.JavaContainerBuilderHelper;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLoggerBuilder;
import com.google.cloud.tools.jib.plugins.common.logging.ProgressDisplayGenerator;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.Os;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProjectProperties
implements ProjectProperties {
    public static final String PLUGIN_NAME = "jib-maven-plugin";
    public static final String PLUGIN_KEY = "com.google.cloud.tools:jib-maven-plugin";
    private static final String TOOL_NAME = "jib-maven-plugin";
    private static final String JAR_PLUGIN_NAME = "'maven-jar-plugin'";
    private final MavenProject project;
    private final MavenSession session;
    private final SingleThreadedExecutor singleThreadedExecutor = new SingleThreadedExecutor();
    private final ConsoleLogger consoleLogger;

    static MavenProjectProperties getForProject(MavenProject project, MavenSession session, Log log) {
        return new MavenProjectProperties(project, session, log);
    }

    @Nullable
    public static String getProperty(String propertyName, @Nullable MavenProject project, @Nullable MavenSession session) {
        if (session != null && session.getSystemProperties().containsKey(propertyName)) {
            return session.getSystemProperties().getProperty(propertyName);
        }
        if (project != null && project.getProperties().containsKey(propertyName)) {
            return project.getProperties().getProperty(propertyName);
        }
        return null;
    }

    @VisibleForTesting
    static boolean isProgressFooterEnabled(MavenSession session) {
        if (!session.getRequest().isInteractiveMode()) {
            return false;
        }
        if ("plain".equals(System.getProperty("jib.console"))) {
            return false;
        }
        if (Os.isFamily((String)"windows")) {
            return true;
        }
        return System.console() != null && !"dumb".equals(System.getenv("TERM"));
    }

    @VisibleForTesting
    static int getVersionFromString(String versionString) {
        if (versionString.startsWith("1.")) {
            if (versionString.length() >= 3 && Character.isDigit(versionString.charAt(2))) {
                return versionString.charAt(2) - 48;
            }
            return 0;
        }
        int dotIndex = versionString.indexOf(".");
        try {
            if (dotIndex == -1) {
                return Integer.parseInt(versionString);
            }
            return Integer.parseInt(versionString.substring(0, versionString.indexOf(".")));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @VisibleForTesting
    MavenProjectProperties(MavenProject project, MavenSession session, Log log) {
        this.project = project;
        this.session = session;
        ConsoleLoggerBuilder consoleLoggerBuilder = (MavenProjectProperties.isProgressFooterEnabled(session) ? ConsoleLoggerBuilder.rich(this.singleThreadedExecutor) : ConsoleLoggerBuilder.plain(this.singleThreadedExecutor).progress(arg_0 -> ((Log)log).info(arg_0))).lifecycle(arg_0 -> ((Log)log).info(arg_0));
        if (log.isDebugEnabled()) {
            consoleLoggerBuilder.debug(arg_0 -> ((Log)log).debug(arg_0)).info(arg_0 -> ((Log)log).debug(arg_0));
        }
        if (log.isWarnEnabled()) {
            consoleLoggerBuilder.warn(arg_0 -> ((Log)log).warn(arg_0));
        }
        if (log.isErrorEnabled()) {
            consoleLoggerBuilder.error(arg_0 -> ((Log)log).error(arg_0));
        }
        this.consoleLogger = consoleLoggerBuilder.build();
    }

    @Override
    public JibContainerBuilder createContainerBuilder(RegistryImage baseImage, AbsoluteUnixPath appRoot, ContainerizingMode containerizingMode) throws IOException {
        JavaContainerBuilder javaContainerBuilder = JavaContainerBuilder.from(baseImage).setAppRoot(appRoot);
        try {
            if (this.isWarProject()) {
                Path explodedWarPath = Paths.get(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName());
                return JavaContainerBuilderHelper.fromExplodedWar(javaContainerBuilder, explodedWarPath);
            }
            switch (containerizingMode) {
                case EXPLODED: {
                    Path classesOutputDirectory = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
                    Predicate<Path> isClassFile = path -> path.getFileName().toString().endsWith(".class");
                    javaContainerBuilder.addResources(classesOutputDirectory, isClassFile.negate()).addClasses(classesOutputDirectory, isClassFile);
                    break;
                }
                case PACKAGED: {
                    javaContainerBuilder.addToClasspath(this.getJarArtifact());
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown containerizing mode: " + (Object)((Object)containerizingMode));
                }
            }
            Map<JavaContainerBuilder.LayerType, List<Path>> classifiedDependencies = this.classifyDependencies(this.project.getArtifacts(), this.session.getProjects().stream().map(MavenProject::getArtifact).collect(Collectors.toSet()));
            return javaContainerBuilder.addDependencies((List)Preconditions.checkNotNull(classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.DEPENDENCIES))).addSnapshotDependencies((List)Preconditions.checkNotNull(classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.SNAPSHOT_DEPENDENCIES))).addProjectDependencies((List)Preconditions.checkNotNull(classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES))).toContainerBuilder();
        }
        catch (IOException ex) {
            throw new IOException("Obtaining project build output files failed; make sure you have " + (containerizingMode == ContainerizingMode.PACKAGED ? "packaged" : "compiled") + " your project before trying to build the image. (Did you accidentally run \"mvn clean jib:build\" instead of \"mvn clean " + (containerizingMode == ContainerizingMode.PACKAGED ? "package" : "compile") + " jib:build\"?)", ex);
        }
    }

    @VisibleForTesting
    Map<JavaContainerBuilder.LayerType, List<Path>> classifyDependencies(Set<Artifact> dependencies, Set<Artifact> projectArtifacts) {
        HashMap<JavaContainerBuilder.LayerType, List<Path>> classifiedDependencies = new HashMap<JavaContainerBuilder.LayerType, List<Path>>();
        classifiedDependencies.put(JavaContainerBuilder.LayerType.DEPENDENCIES, new ArrayList());
        classifiedDependencies.put(JavaContainerBuilder.LayerType.SNAPSHOT_DEPENDENCIES, new ArrayList());
        classifiedDependencies.put(JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES, new ArrayList());
        for (Artifact artifact : dependencies) {
            if (projectArtifacts.contains(artifact)) {
                ((List)classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.PROJECT_DEPENDENCIES)).add(artifact.getFile().toPath());
                continue;
            }
            if (artifact.isSnapshot()) {
                ((List)classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.SNAPSHOT_DEPENDENCIES)).add(artifact.getFile().toPath());
                continue;
            }
            ((List)classifiedDependencies.get((Object)JavaContainerBuilder.LayerType.DEPENDENCIES)).add(artifact.getFile().toPath());
        }
        return classifiedDependencies;
    }

    @Override
    public List<Path> getClassFiles() throws IOException {
        return new DirectoryWalker(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0])).walk().asList();
    }

    @Override
    public void waitForLoggingThread() {
        this.singleThreadedExecutor.shutDownAndAwaitTermination();
    }

    @Override
    public void configureEventHandlers(Containerizer containerizer) {
        containerizer.addEventHandler(LogEvent.class, this::log).addEventHandler(TimerEvent.class, new TimerEventHandler(message -> this.consoleLogger.log(LogEvent.Level.DEBUG, (String)message))).addEventHandler(ProgressEvent.class, new ProgressEventHandler(update -> this.consoleLogger.setFooter(ProgressDisplayGenerator.generateProgressDisplay(update.getProgress(), update.getUnfinishedLeafTasks()))));
    }

    @Override
    public void log(LogEvent logEvent) {
        this.consoleLogger.log(logEvent.getLevel(), logEvent.getMessage());
    }

    @Override
    public String getToolName() {
        return "jib-maven-plugin";
    }

    @Override
    public String getPluginName() {
        return "jib-maven-plugin";
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        Plugin mavenJarPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-jar-plugin");
        if (mavenJarPlugin != null) {
            Xpp3Dom jarConfiguration = (Xpp3Dom)mavenJarPlugin.getConfiguration();
            if (jarConfiguration == null) {
                return null;
            }
            Xpp3Dom archiveObject = jarConfiguration.getChild("archive");
            if (archiveObject == null) {
                return null;
            }
            Xpp3Dom manifestObject = archiveObject.getChild("manifest");
            if (manifestObject == null) {
                return null;
            }
            Xpp3Dom mainClassObject = manifestObject.getChild("mainClass");
            if (mainClassObject == null) {
                return null;
            }
            return mainClassObject.getValue();
        }
        return null;
    }

    @Override
    public Path getDefaultCacheDirectory() {
        return Paths.get(this.project.getBuild().getDirectory(), "jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        String packaging = this.project.getPackaging();
        return "war".equals(packaging) || "gwt-app".equals(packaging);
    }

    @Override
    public String getName() {
        return this.project.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.project.getVersion();
    }

    @Override
    public int getMajorJavaVersion() {
        Xpp3Dom pluginConfiguration;
        if (this.project.getProperties().getProperty("maven.compiler.target") != null) {
            return MavenProjectProperties.getVersionFromString(this.project.getProperties().getProperty("maven.compiler.target"));
        }
        if (this.project.getProperties().getProperty("maven.compiler.release") != null) {
            return MavenProjectProperties.getVersionFromString(this.project.getProperties().getProperty("maven.compiler.release"));
        }
        Plugin mavenCompilerPlugin = this.project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (mavenCompilerPlugin != null && (pluginConfiguration = (Xpp3Dom)mavenCompilerPlugin.getConfiguration()) != null) {
            Xpp3Dom target = pluginConfiguration.getChild("target");
            if (target != null) {
                return MavenProjectProperties.getVersionFromString(target.getValue());
            }
            Xpp3Dom release = pluginConfiguration.getChild("release");
            if (release != null) {
                return MavenProjectProperties.getVersionFromString(release.getValue());
            }
        }
        return 6;
    }

    @Override
    public boolean isOffline() {
        return this.session.isOffline();
    }

    @VisibleForTesting
    Path getJarArtifact() {
        String jarName = this.project.getBuild().getFinalName() + ".jar";
        return Paths.get(this.project.getBuild().getDirectory(), jarName);
    }
}

