/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.global;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Range;

public class JibSystemProperties {
    @VisibleForTesting
    public static final String HTTP_TIMEOUT = "jib.httpTimeout";
    @VisibleForTesting
    static final String CROSS_REPOSITORY_BLOB_MOUNTS = "jib.blobMounts";
    @VisibleForTesting
    public static final String SEND_CREDENTIALS_OVER_HTTP = "sendCredentialsOverHttp";
    private static final String SERIALIZE = "jibSerialize";
    private static final String DISABLE_USER_AGENT = "_JIB_DISABLE_USER_AGENT";

    public static int getHttpTimeout() {
        if (Integer.getInteger(HTTP_TIMEOUT) == null) {
            return 20000;
        }
        return Integer.getInteger(HTTP_TIMEOUT);
    }

    public static boolean useCrossRepositoryBlobMounts() {
        return System.getProperty(CROSS_REPOSITORY_BLOB_MOUNTS) == null || Boolean.getBoolean(CROSS_REPOSITORY_BLOB_MOUNTS);
    }

    public static boolean serializeExecution() {
        return Boolean.getBoolean(SERIALIZE);
    }

    public static boolean sendCredentialsOverHttp() {
        return Boolean.getBoolean(SEND_CREDENTIALS_OVER_HTTP);
    }

    public static boolean isUserAgentEnabled() {
        return Strings.isNullOrEmpty((String)System.getProperty(DISABLE_USER_AGENT));
    }

    public static void checkHttpTimeoutProperty() throws NumberFormatException {
        JibSystemProperties.checkNumericSystemProperty(HTTP_TIMEOUT, (Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(0)));
    }

    public static void checkProxyPortProperty() throws NumberFormatException {
        JibSystemProperties.checkNumericSystemProperty("http.proxyPort", (Range<Integer>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(65535)));
        JibSystemProperties.checkNumericSystemProperty("https.proxyPort", (Range<Integer>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(65535)));
    }

    private static void checkNumericSystemProperty(String property, Range<Integer> validRange) {
        int parsed;
        String value = System.getProperty(property);
        if (value == null) {
            return;
        }
        try {
            parsed = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(property + " must be an integer: " + value);
        }
        if (validRange.hasLowerBound() && (Integer)validRange.lowerEndpoint() > parsed) {
            throw new NumberFormatException(property + " cannot be less than " + validRange.lowerEndpoint() + ": " + value);
        }
        if (validRange.hasUpperBound() && (Integer)validRange.upperEndpoint() < parsed) {
            throw new NumberFormatException(property + " cannot be greater than " + validRange.upperEndpoint() + ": " + value);
        }
    }

    private JibSystemProperties() {
    }
}

