/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snaker.engine.Assignment;
import org.snaker.engine.AssignmentHandler;
import org.snaker.engine.Completion;
import org.snaker.engine.ITaskService;
import org.snaker.engine.SnakerException;
import org.snaker.engine.TaskAccessStrategy;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.core.Execution;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.entity.TaskActor;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.DateHelper;
import org.snaker.engine.helper.JsonHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.impl.GeneralAccessStrategy;
import org.snaker.engine.model.CustomModel;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.model.TaskModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService
extends AccessService
implements ITaskService {
    private static final String START = "start";
    private TaskAccessStrategy strategy = null;

    @Override
    public Task complete(String taskId) {
        return this.complete(taskId, null, null);
    }

    @Override
    public Task complete(String taskId, String operator) {
        return this.complete(taskId, operator, null);
    }

    @Override
    public Task complete(String taskId, String operator, Map<String, Object> args) {
        Task task = this.access().getTask(taskId);
        AssertHelper.notNull(task, "\u6307\u5b9a\u7684\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        task.setVariable(JsonHelper.toJson(args));
        if (!this.isAllowed(task, operator)) {
            throw new SnakerException("\u5f53\u524d\u53c2\u4e0e\u8005[" + operator + "]\u4e0d\u5141\u8bb8\u6267\u884c\u4efb\u52a1[taskId=" + taskId + "]");
        }
        HistoryTask history = new HistoryTask(task);
        history.setFinishTime(DateHelper.getTime());
        history.setTaskState(STATE_FINISH);
        history.setOperator(operator);
        if (history.getActorIds() == null) {
            List<TaskActor> actors = this.access().getTaskActorsByTaskId(task.getId());
            String[] actorIds = new String[actors.size()];
            for (int i = 0; i < actors.size(); ++i) {
                actorIds[i] = actors.get(i).getActorId();
            }
            history.setActorIds(actorIds);
        }
        this.access().saveHistory(history);
        this.access().deleteTask(task);
        Completion completion = this.getCompletion();
        if (completion != null) {
            completion.complete(history);
        }
        return task;
    }

    @Override
    public void updateTask(Task task) {
        this.access().updateTask(task);
    }

    @Override
    public HistoryTask history(Execution execution, CustomModel model) {
        HistoryTask historyTask = new HistoryTask();
        historyTask.setId(StringHelper.getPrimaryKey());
        historyTask.setOrderId(execution.getOrder().getId());
        String currentTime = DateHelper.getTime();
        historyTask.setCreateTime(currentTime);
        historyTask.setFinishTime(currentTime);
        historyTask.setDisplayName(model.getDisplayName());
        historyTask.setTaskName(model.getName());
        historyTask.setTaskState(STATE_FINISH);
        historyTask.setTaskType(TaskModel.TaskType.Record.ordinal());
        historyTask.setParentTaskId(execution.getTask() == null ? START : execution.getTask().getId());
        historyTask.setVariable(JsonHelper.toJson(execution.getArgs()));
        this.access().saveHistory(historyTask);
        return historyTask;
    }

    @Override
    public Task take(String taskId, String operator) {
        Task task = this.access().getTask(taskId);
        AssertHelper.notNull(task, "\u6307\u5b9a\u7684\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        if (!this.isAllowed(task, operator)) {
            throw new SnakerException("\u5f53\u524d\u53c2\u4e0e\u8005[" + operator + "]\u4e0d\u5141\u8bb8\u63d0\u53d6\u4efb\u52a1[taskId=" + taskId + "]");
        }
        task.setOperator(operator);
        task.setFinishTime(DateHelper.getTime());
        this.access().updateTask(task);
        return task;
    }

    @Override
    public Task resume(String taskId, String operator) {
        HistoryTask histTask = this.access().getHistTask(taskId);
        AssertHelper.notNull(histTask, "\u6307\u5b9a\u7684\u5386\u53f2\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        boolean isAllowed = true;
        if (StringHelper.isNotEmpty(histTask.getOperator())) {
            isAllowed = histTask.getOperator().equals(operator);
        }
        if (isAllowed) {
            Task task = histTask.undoTask();
            task.setId(StringHelper.getPrimaryKey());
            task.setCreateTime(DateHelper.getTime());
            this.access().saveTask(task);
            this.assignTask(task.getId(), task.getOperator());
            return task;
        }
        throw new SnakerException("\u5f53\u524d\u53c2\u4e0e\u8005[" + operator + "]\u4e0d\u5141\u8bb8\u5524\u9192\u5386\u53f2\u4efb\u52a1[taskId=" + taskId + "]");
    }

    @Override
    public void addTaskActor(String taskId, String ... actors) {
        this.addTaskActor(taskId, (Integer)null, actors);
    }

    @Override
    public void addTaskActor(String taskId, Integer performType, String ... actors) {
        Task task = this.access().getTask(taskId);
        AssertHelper.notNull(task, "\u6307\u5b9a\u7684\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        if (!task.isMajor()) {
            return;
        }
        if (performType == null) {
            performType = task.getPerformType();
        }
        if (performType == null) {
            performType = 0;
        }
        switch (performType) {
            case 0: {
                this.assignTask(task.getId(), actors);
                Map<String, Object> data = task.getVariableMap();
                String oldActor = (String)data.get("S-ACTOR");
                data.put("S-ACTOR", oldActor + "," + StringHelper.getStringByArray(actors));
                task.setVariable(JsonHelper.toJson(data));
                this.access().updateTask(task);
                break;
            }
            case 1: {
                try {
                    for (String actor : actors) {
                        Task newTask = (Task)task.clone();
                        newTask.setId(StringHelper.getPrimaryKey());
                        newTask.setCreateTime(DateHelper.getTime());
                        newTask.setOperator(actor);
                        Map<String, Object> taskData = task.getVariableMap();
                        taskData.put("S-ACTOR", actor);
                        task.setVariable(JsonHelper.toJson(taskData));
                        this.access().saveTask(newTask);
                        this.assignTask(newTask.getId(), actor);
                    }
                    break;
                }
                catch (CloneNotSupportedException ex) {
                    throw new SnakerException("\u4efb\u52a1\u5bf9\u8c61\u4e0d\u652f\u6301\u590d\u5236", ex.getCause());
                }
            }
        }
    }

    @Override
    public void removeTaskActor(String taskId, String ... actors) {
        Task task = this.access().getTask(taskId);
        AssertHelper.notNull(task, "\u6307\u5b9a\u7684\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        if (actors == null || actors.length == 0) {
            return;
        }
        if (task.isMajor()) {
            this.access().removeTaskActor(task.getId(), actors);
            Map<String, Object> taskData = task.getVariableMap();
            String actorStr = (String)taskData.get("S-ACTOR");
            if (StringHelper.isNotEmpty(actorStr)) {
                String[] actorArray = actorStr.split(",");
                StringBuilder newActor = new StringBuilder(actorStr.length());
                for (String actor : actorArray) {
                    boolean isMatch = false;
                    if (StringHelper.isEmpty(actor)) continue;
                    for (String removeActor : actors) {
                        if (!actor.equals(removeActor)) continue;
                        isMatch = true;
                        break;
                    }
                    if (isMatch) continue;
                    newActor.append(actor).append(",");
                }
                newActor.deleteCharAt(newActor.length() - 1);
                taskData.put("S-ACTOR", newActor.toString());
                task.setVariable(JsonHelper.toJson(taskData));
                this.access().updateTask(task);
            }
        }
    }

    @Override
    public Task withdrawTask(String taskId, String operator) {
        HistoryTask hist = this.access().getHistTask(taskId);
        AssertHelper.notNull(hist, "\u6307\u5b9a\u7684\u5386\u53f2\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        List<Task> tasks = hist.isPerformAny() ? this.access().getNextActiveTasks(hist.getId()) : this.access().getNextActiveTasks(hist.getOrderId(), hist.getTaskName(), hist.getParentTaskId());
        if (tasks == null || tasks.isEmpty()) {
            throw new SnakerException("\u540e\u7eed\u6d3b\u52a8\u4efb\u52a1\u5df2\u5b8c\u6210\u6216\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u64a4\u56de.");
        }
        for (Task task : tasks) {
            this.access().deleteTask(task);
        }
        Task task = hist.undoTask();
        task.setId(StringHelper.getPrimaryKey());
        task.setCreateTime(DateHelper.getTime());
        this.access().saveTask(task);
        this.assignTask(task.getId(), task.getOperator());
        return task;
    }

    @Override
    public Task rejectTask(ProcessModel model, Task currentTask) {
        HistoryTask history;
        NodeModel parent;
        String parentTaskId = currentTask.getParentTaskId();
        if (StringHelper.isEmpty(parentTaskId) || parentTaskId.equals(START)) {
            throw new SnakerException("\u4e0a\u4e00\u6b65\u4efb\u52a1ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u9a73\u56de\u81f3\u4e0a\u4e00\u6b65\u5904\u7406");
        }
        NodeModel current = model.getNode(currentTask.getTaskName());
        if (!NodeModel.canRejected(current, parent = model.getNode((history = this.access().getHistTask(parentTaskId)).getTaskName()))) {
            throw new SnakerException("\u65e0\u6cd5\u9a73\u56de\u81f3\u4e0a\u4e00\u6b65\u5904\u7406\uff0c\u8bf7\u786e\u8ba4\u4e0a\u4e00\u6b65\u9aa4\u5e76\u975efork\u3001join\u3001suprocess\u4ee5\u53ca\u4f1a\u7b7e\u4efb\u52a1");
        }
        Task task = history.undoTask();
        task.setId(StringHelper.getPrimaryKey());
        task.setCreateTime(DateHelper.getTime());
        task.setOperator(history.getOperator());
        this.access().saveTask(task);
        this.assignTask(task.getId(), task.getOperator());
        return task;
    }

    private void assignTask(String taskId, String ... actorIds) {
        if (actorIds == null || actorIds.length == 0) {
            return;
        }
        for (String actorId : actorIds) {
            if (StringHelper.isEmpty(actorId)) continue;
            TaskActor taskActor = new TaskActor();
            taskActor.setTaskId(taskId);
            taskActor.setActorId(actorId);
            this.access().saveTaskActor(taskActor);
        }
    }

    @Override
    public List<Task> createNewTask(String taskId, int taskType, String ... actors) {
        Task task = this.access().getTask(taskId);
        AssertHelper.notNull(task, "\u6307\u5b9a\u7684\u4efb\u52a1[id=" + taskId + "]\u4e0d\u5b58\u5728");
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            Task newTask = (Task)task.clone();
            newTask.setTaskType(taskType);
            newTask.setCreateTime(DateHelper.getTime());
            newTask.setParentTaskId(taskId);
            tasks.add(this.saveTask(newTask, actors));
        }
        catch (CloneNotSupportedException e) {
            throw new SnakerException("\u4efb\u52a1\u5bf9\u8c61\u4e0d\u652f\u6301\u590d\u5236", e.getCause());
        }
        return tasks;
    }

    @Override
    public TaskModel getTaskModel(String taskId) {
        Task task = this.access().getTask(taskId);
        AssertHelper.notNull(task);
        Order order = this.access().getOrder(task.getOrderId());
        AssertHelper.notNull(order);
        Process process = ServiceContext.getEngine().process().getProcessById(order.getProcessId());
        ProcessModel model = process.getModel();
        NodeModel nodeModel = model.getNode(task.getTaskName());
        AssertHelper.notNull(nodeModel, "\u4efb\u52a1id\u65e0\u6cd5\u627e\u5230\u8282\u70b9\u6a21\u578b.");
        if (nodeModel instanceof TaskModel) {
            return (TaskModel)nodeModel;
        }
        throw new IllegalArgumentException("\u4efb\u52a1id\u627e\u5230\u7684\u8282\u70b9\u6a21\u578b\u4e0d\u5339\u914d");
    }

    @Override
    public List<Task> createTask(TaskModel taskModel, Execution execution) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        Map<String, Object> args = execution.getArgs();
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        Date expireDate = DateHelper.processTime(args, taskModel.getExpireTime());
        Date remindDate = DateHelper.processTime(args, taskModel.getReminderTime());
        String form = (String)args.get(taskModel.getForm());
        String actionUrl = StringHelper.isEmpty(form) ? taskModel.getForm() : form;
        String[] actors = this.getTaskActors(taskModel, execution);
        args.put("S-ACTOR", StringHelper.getStringByArray(actors));
        Task task = this.createTaskBase(taskModel, execution);
        task.setActionUrl(actionUrl);
        task.setExpireDate(expireDate);
        task.setExpireTime(DateHelper.parseTime(expireDate));
        task.setVariable(JsonHelper.toJson(args));
        if (taskModel.isPerformAny()) {
            task = this.saveTask(task, actors);
            task.setRemindDate(remindDate);
            tasks.add(task);
        } else if (taskModel.isPerformAll()) {
            for (String actor : actors) {
                Task singleTask;
                try {
                    singleTask = (Task)task.clone();
                }
                catch (CloneNotSupportedException e) {
                    singleTask = task;
                }
                singleTask = this.saveTask(singleTask, actor);
                singleTask.setRemindDate(remindDate);
                tasks.add(singleTask);
            }
        }
        return tasks;
    }

    private Task createTaskBase(TaskModel model, Execution execution) {
        Task task = new Task();
        task.setOrderId(execution.getOrder().getId());
        task.setTaskName(model.getName());
        task.setDisplayName(model.getDisplayName());
        task.setCreateTime(DateHelper.getTime());
        if (model.isMajor()) {
            task.setTaskType(TaskModel.TaskType.Major.ordinal());
        } else {
            task.setTaskType(TaskModel.TaskType.Aidant.ordinal());
        }
        task.setParentTaskId(execution.getTask() == null ? START : execution.getTask().getId());
        task.setModel(model);
        return task;
    }

    private Task saveTask(Task task, String ... actors) {
        task.setId(StringHelper.getPrimaryKey());
        task.setPerformType(TaskModel.PerformType.ANY.ordinal());
        this.access().saveTask(task);
        this.assignTask(task.getId(), actors);
        task.setActorIds(actors);
        return task;
    }

    private String[] getTaskActors(TaskModel model, Execution execution) {
        Object assigneeObject = null;
        AssignmentHandler handler = model.getAssignmentHandlerObject();
        if (StringHelper.isNotEmpty(model.getAssignee())) {
            assigneeObject = execution.getArgs().get(model.getAssignee());
        } else if (handler != null) {
            assigneeObject = handler instanceof Assignment ? ((Assignment)handler).assign(model, execution) : handler.assign(execution);
        }
        return this.getTaskActors(assigneeObject == null ? model.getAssignee() : assigneeObject);
    }

    private String[] getTaskActors(Object actors) {
        if (actors == null) {
            return null;
        }
        if (actors instanceof String) {
            return ((String)actors).split(",");
        }
        if (actors instanceof List) {
            List list = (List)actors;
            String[] results = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                results[i] = (String)list.get(i);
            }
            return results;
        }
        if (actors instanceof Long) {
            String[] results = new String[]{String.valueOf((Long)actors)};
            return results;
        }
        if (actors instanceof Integer) {
            String[] results = new String[]{String.valueOf((Integer)actors)};
            return results;
        }
        if (actors instanceof String[]) {
            return (String[])actors;
        }
        throw new SnakerException("\u4efb\u52a1\u53c2\u4e0e\u8005\u5bf9\u8c61[" + actors + "]\u7c7b\u578b\u4e0d\u652f\u6301." + "\u5408\u6cd5\u53c2\u6570\u793a\u4f8b:Long,Integer,new String[]{},'10000,20000',List<String>");
    }

    @Override
    public boolean isAllowed(Task task, String operator) {
        List<TaskActor> actors;
        if (StringHelper.isNotEmpty(operator)) {
            if ("snaker.admin".equalsIgnoreCase(operator) || "snaker.auto".equalsIgnoreCase(operator)) {
                return true;
            }
            if (StringHelper.isNotEmpty(task.getOperator())) {
                return operator.equals(task.getOperator());
            }
        }
        if ((actors = this.access().getTaskActorsByTaskId(task.getId())) == null || actors.isEmpty()) {
            return true;
        }
        return !StringHelper.isEmpty(operator) && this.getStrategy().isAllowed(operator, actors);
    }

    public void setStrategy(TaskAccessStrategy strategy) {
        this.strategy = strategy;
    }

    public TaskAccessStrategy getStrategy() {
        if (this.strategy != null) {
            return this.strategy;
        }
        this.strategy = ServiceContext.find(TaskAccessStrategy.class);
        if (this.strategy == null) {
            ServiceContext.put(TaskAccessStrategy.class.getName(), GeneralAccessStrategy.class);
            this.strategy = ServiceContext.find(TaskAccessStrategy.class);
        }
        return this.strategy;
    }
}

