/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.jdbc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbutils.handlers.AbstractListHandler;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.jdbc.JdbcHelper;
import org.snaker.engine.helper.ClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertyHandler<T>
extends AbstractListHandler<T> {
    private Class<T> mappedClass;
    private Map<String, PropertyDescriptor> mappedFields;

    public BeanPropertyHandler(Class<T> mappedClass) {
        this.initialize(mappedClass);
    }

    protected T handleRow(ResultSet rs) throws SQLException {
        T mappedObject = ClassHelper.instantiate(this.mappedClass);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String column = JdbcHelper.lookupColumnName(rsmd, index);
            PropertyDescriptor pd = this.mappedFields.get(column.replaceAll(" ", "").toLowerCase());
            if (pd == null) continue;
            try {
                Object value = JdbcHelper.getResultSetValue(rs, index, pd.getPropertyType());
                try {
                    BeanUtils.setProperty(mappedObject, (String)pd.getName(), (Object)value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return mappedObject;
    }

    protected void initialize(Class<T> mappedClass) {
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] pds = null;
        try {
            pds = this.propertyDescriptors(mappedClass);
        }
        catch (SQLException e) {
            throw new SnakerException(e.getMessage(), e.getCause());
        }
        for (PropertyDescriptor pd : pds) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(pd.getName().toLowerCase(), pd);
            String underscoredName = BeanPropertyHandler.underscoreName(pd.getName());
            if (pd.getName().toLowerCase().equals(underscoredName)) continue;
            this.mappedFields.put(underscoredName, pd);
        }
    }

    private static String underscoreName(String name) {
        StringBuilder result = new StringBuilder();
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toLowerCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase())) {
                    result.append("_");
                    result.append(s.toLowerCase());
                    continue;
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }
}

