/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.wxa.Commit;
import weixin.popular.bean.wxa.GetAuditstatusResult;
import weixin.popular.bean.wxa.GetCategoryResult;
import weixin.popular.bean.wxa.GetPageResult;
import weixin.popular.bean.wxa.GetQrcodeResult;
import weixin.popular.bean.wxa.Getwxacode;
import weixin.popular.bean.wxa.Getwxacodeunlimit;
import weixin.popular.bean.wxa.ModifyDomain;
import weixin.popular.bean.wxa.ModifyDomainResult;
import weixin.popular.bean.wxa.SubmitAudit;
import weixin.popular.bean.wxa.SubmitAuditResult;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;

public class WxaAPI
extends BaseAPI {
    public static ModifyDomainResult modify_domain(String access_token, ModifyDomain modifyDomain) {
        String json = JsonUtil.toJSONString(modifyDomain);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/modify_domain").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ModifyDomainResult.class);
    }

    public static BaseResult bind_tester(String access_token, String wechatid) {
        String json = String.format("{\"wechatid\":\"%s\"}", wechatid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/bind_tester").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult unbind_tester(String access_token, String wechatid) {
        String json = String.format("{\"wechatid\":\"%s\"}", wechatid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/unbind_tester").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult commit(String access_token, Commit commit) {
        String json = JsonUtil.toJSONString(commit);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/commit").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GetQrcodeResult get_qrcode(String access_token) {
        block18: {
            HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/wxa/get_qrcode").addParameter("access_token", API.accessToken(access_token)).build();
            CloseableHttpResponse httpResponse = LocalHttpClient.execute(httpUriRequest);
            try {
                int status = httpResponse.getStatusLine().getStatusCode();
                Header header = httpResponse.getFirstHeader("Content-disposition");
                if (header != null && header.getValue().endsWith("filename=\"QRCode.jpg\"")) {
                    if (status == 200) {
                        byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                        GetQrcodeResult result = new GetQrcodeResult();
                        result.setBufferedImage(ImageIO.read(new ByteArrayInputStream(bytes)));
                        GetQrcodeResult getQrcodeResult = result;
                        return getQrcodeResult;
                    }
                    break block18;
                }
                String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                GetQrcodeResult getQrcodeResult = JsonUtil.parseObject(body, GetQrcodeResult.class);
                return getQrcodeResult;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static GetCategoryResult get_category(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/wxa/get_category").addParameter("access_token", API.accessToken(access_token)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetCategoryResult.class);
    }

    public static GetPageResult get_page(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://api.weixin.qq.com/wxa/get_page").addParameter("access_token", API.accessToken(access_token)).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetPageResult.class);
    }

    public static SubmitAuditResult submit_audit(String access_token, SubmitAudit submitAudit) {
        String json = JsonUtil.toJSONString(submitAudit);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/submit_audit").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, SubmitAuditResult.class);
    }

    public static GetAuditstatusResult get_auditstatus(String access_token, String auditid) {
        String json = String.format("{\"auditid\":\"%s\"}", auditid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/get_auditstatus").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, GetAuditstatusResult.class);
    }

    public static BaseResult release(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/release").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity("{}", Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult change_visitstatus(String access_token, String action) {
        String json = String.format("{\"action\":\"%s\"}", action);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/change_visitstatus").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getwxacode(String access_token, Getwxacode getwxacode) {
        String json = JsonUtil.toJSONString(getwxacode);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/getwxacode").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        CloseableHttpResponse httpResponse = LocalHttpClient.execute(httpUriRequest);
        try {
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status == 200) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                return bufferedImage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getwxacodeunlimit(String access_token, Getwxacodeunlimit getwxacodeunlimit) {
        String json = JsonUtil.toJSONString(getwxacodeunlimit);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/wxa/getwxacode").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        CloseableHttpResponse httpResponse = LocalHttpClient.execute(httpUriRequest);
        try {
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status == 200) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                return bufferedImage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

