/*
 * Decompiled with CFR 0.152.
 */
package com.reger.dubbo.config;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.reger.dubbo.config.AnnotationBean;
import com.reger.dubbo.properties.DubboProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@Configuration
public class DubboAutoConfiguration
extends AnnotationBean
implements EnvironmentAware {
    static Logger logger = LoggerFactory.getLogger(DubboAutoConfiguration.class);
    private static final long serialVersionUID = 1L;
    private ConfigurableEnvironment environment;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public <T> T getPropertiesConfigurationBean(String targetName, Class<T> types) {
        PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(types);
        factory.setPropertySources((PropertySources)this.environment.getPropertySources());
        factory.setConversionService((ConversionService)this.environment.getConversionService());
        factory.setIgnoreInvalidFields(false);
        factory.setIgnoreUnknownFields(true);
        factory.setIgnoreNestedProperties(true);
        factory.setIgnoreNestedProperties(false);
        factory.setTargetName(targetName);
        try {
            factory.bindPropertiesToTarget();
            return (T)factory.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DubboProperties dubboProperties = this.getPropertiesConfigurationBean("spring.dubbo", DubboProperties.class);
        List<ProtocolConfig> protocols = dubboProperties.getProtocols();
        if (protocols == null) {
            protocols = new ArrayList<ProtocolConfig>();
        }
        if (dubboProperties.getProtocol() != null) {
            protocols.add(dubboProperties.getProtocol());
        }
        this.registerThis(dubboProperties.getBasePackage(), beanFactory);
        this.registerApplication(dubboProperties.getApplication(), beanFactory);
        this.registerProtocols(protocols, beanFactory);
        this.registerRegistry(dubboProperties.getRegistry(), beanFactory);
        this.registerMonitor(dubboProperties.getMonitor(), beanFactory);
        this.registerModule(dubboProperties.getModule(), beanFactory);
        this.registerProvider(dubboProperties.getProvider(), beanFactory);
        this.registerConsumer(dubboProperties.getConsumer(), beanFactory);
        this.registerReferences(dubboProperties.getReferences(), beanFactory);
        this.registerServices(dubboProperties.getServices(), beanFactory);
        super.postProcessBeanFactory(beanFactory);
    }

    private void registerConsumer(ConsumerConfig consumer, ConfigurableListableBeanFactory beanFactory) {
        if (consumer != null) {
            beanFactory.registerSingleton("consumerConfig", (Object)consumer);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u6d88\u8d39\u8005\u53c2\u6570");
        }
    }

    private void registerProvider(ProviderConfig provider, ConfigurableListableBeanFactory beanFactory) {
        if (provider != null) {
            beanFactory.registerSingleton("providerConfig", (Object)provider);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u7684\u751f\u6210\u8005\u53c2\u6570");
        }
    }

    private void registerModule(ModuleConfig module, ConfigurableListableBeanFactory beanFactory) {
        if (module != null) {
            beanFactory.registerSingleton("moduleConfig", (Object)module);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u6a21\u5757\u4fe1\u606f");
        }
    }

    private void registerReferences(List<ReferenceConfig<?>> references, ConfigurableListableBeanFactory beanFactory) {
        if (references == null || references.isEmpty()) {
            return;
        }
        for (ReferenceConfig<?> referenceConfig : references) {
            String beanName = referenceConfig.getId() + "-ReferenceConfig";
            beanFactory.registerSingleton(beanName, referenceConfig);
            beanFactory.registerSingleton(referenceConfig.getId(), referenceConfig.get());
            logger.debug("\u6ce8\u518c\u8c03\u7528\u4fe1\u606f{} \u5b8c\u6bd5", (Object)beanName);
        }
    }

    private void registerServices(List<ServiceConfig<?>> services, ConfigurableListableBeanFactory beanFactory) {
        if (services == null || services.isEmpty()) {
            return;
        }
        for (ServiceConfig<?> serviceConfig : services) {
            String beanName = serviceConfig.getId() + "-ServiceConfig";
            beanFactory.registerSingleton(beanName, serviceConfig);
            serviceConfig.export();
            logger.debug("\u6ce8\u518c\u670d\u52a1\u4fe1\u606f{} \u5b8c\u6bd5", (Object)beanName);
        }
    }

    private void registerMonitor(MonitorConfig monitorConfig, ConfigurableListableBeanFactory beanFactory) {
        if (monitorConfig != null) {
            beanFactory.registerSingleton("monitorConfig", (Object)monitorConfig);
        } else {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u76d1\u63a7\u4e2d\u5fc3");
        }
    }

    private void registerRegistry(RegistryConfig registryConfig, ConfigurableListableBeanFactory beanFactory) {
        if (registryConfig != null) {
            beanFactory.registerSingleton("registryConfig", (Object)registryConfig);
        } else {
            logger.info("dubbo \u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3");
        }
    }

    private void registerThis(String annotationPackages, ConfigurableListableBeanFactory beanFactory) {
        if (StringUtils.isEmpty((Object)annotationPackages)) {
            logger.warn(" dubbo\u6ca1\u6709\u914d\u7f6e\u6ce8\u89e3\u670d\u52a1\u6240\u5728\u7684\u76ee\u5f55");
        }
        this.setPackage(annotationPackages);
        super.setId("dubboAnnotationPackageS");
    }

    private void registerApplication(ApplicationConfig applicationConfig, ConfigurableListableBeanFactory beanFactory) {
        if (applicationConfig != null) {
            String name = applicationConfig.getName();
            if (StringUtils.isEmpty((Object)name)) {
                name = "application";
            }
            beanFactory.registerSingleton(name, (Object)applicationConfig);
        } else {
            logger.warn("dubbo \u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u540d\u4fe1\u606f");
        }
    }

    private void registerProtocol(ProtocolConfig protocol, ConfigurableListableBeanFactory beanFactory) {
        if (protocol == null) {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u534f\u8bae,\u5c06\u4f7f\u7528\u9ed8\u8ba4\u534f\u8bae");
            return;
        }
        String beanName = protocol.getName();
        if (protocol.getPort() == null || protocol.getPort() == 0) {
            protocol.setPort(Integer.valueOf(SocketUtils.findAvailableTcpPort((int)53600, (int)53688)));
        }
        beanFactory.registerSingleton(beanName, (Object)protocol);
        logger.debug("\u6ce8\u518c\u534f\u8bae\u4fe1\u606f{}-ProtocolConfig \u5b8c\u6bd5", (Object)beanName);
    }

    private void registerProtocols(List<ProtocolConfig> protocols, ConfigurableListableBeanFactory beanFactory) {
        if (protocols == null || protocols.isEmpty()) {
            logger.debug("dubbo \u6ca1\u6709\u914d\u7f6e\u534f\u8bae,\u5c06\u4f7f\u7528\u9ed8\u8ba4\u534f\u8bae");
            return;
        }
        for (ProtocolConfig protocol : protocols) {
            this.registerProtocol(protocol, beanFactory);
        }
    }
}

