/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.id.util;

import com.gemantic.dal.config.helper.GroupHelper;
import com.gemantic.dal.id.dao.SequenceDao;
import com.gemantic.dal.id.util.IdCenterHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceService {
    private Log log = LogFactory.getLog(SequenceService.class);
    protected SequenceDao dao = new SequenceDao(GroupHelper.getDataSource(IdCenterHelper.getIDCenterDataSourceName()));
    private static SequenceService service;
    protected Map<String, ConcurrentLinkedQueue<Long>> queueMap = new HashMap<String, ConcurrentLinkedQueue<Long>>();
    protected ConcurrentHashMap<String, Integer> spanMap = new ConcurrentHashMap();

    private SequenceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SequenceService getInstance() {
        if (null != service) return service;
        Class<SequenceService> clazz = SequenceService.class;
        synchronized (SequenceService.class) {
            if (null != service) return service;
            service = new SequenceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public synchronized Long nextValue(String seqName) {
        if (null == seqName || StringUtils.isBlank((String)seqName)) {
            this.log.info((Object)"Attention: Sequence's name is null\r\n");
            return null;
        }
        ConcurrentLinkedQueue<Long> queue = this.getQueue(seqName);
        if (queue.isEmpty()) {
            Map ids = this.dao.getSeqIds(seqName);
            if (null != ids && ids.size() > 0) {
                Long minId = (Long)ids.get("oldValue");
                Long maxId = (Long)ids.get("newValue");
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("MinId :" + minId));
                    this.log.info((Object)("MaxId :" + maxId));
                }
                if (minId > maxId) {
                    this.log.error((Object)("config a illegal cache_count for the seq " + seqName));
                    return null;
                }
                if (minId.longValue() == maxId.longValue()) {
                    queue.add((long)minId);
                } else {
                    for (long i = minId.longValue(); i <= maxId; ++i) {
                        queue.add(new Long(i));
                    }
                }
            } else {
                this.log.error((Object)("Error: Cant' get sequence : " + seqName + " from DB \r\n"));
            }
        }
        Long returnId = null;
        returnId = queue.poll();
        if (null == returnId) {
            this.log.error((Object)("Error : Failed to get sequence :" + seqName + " from queue \r\n"));
        }
        return returnId;
    }

    public ConcurrentLinkedQueue<Long> getQueue(String seqName) {
        ConcurrentLinkedQueue<Long> queue = this.queueMap.get(seqName);
        if (null == queue) {
            queue = new ConcurrentLinkedQueue();
            this.queueMap.put(seqName, queue);
        }
        return queue;
    }
}

