/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.config.model.dao;

import com.gemantic.dal.config.DaoConfig;
import com.gemantic.dal.config.model.method.ItemMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;

public class MapItem
implements ItemMethod {
    private static Logger logger = Logger.getLogger(MapItem.class);
    private static final long serialVersionUID = 492940360625423139L;
    private String name;
    private String sqlitem;
    private String sqlcountitem;
    private String sqlType;
    private String keyProperty;
    private String valueProperty;
    private String objectName;
    private Method[] keyMethod;
    private Method valueMethod;
    private String columnName;
    private boolean update = false;

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSqlitem() {
        return this.sqlitem;
    }

    public void setSqlitem(String sqlitem) {
        this.sqlitem = sqlitem;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public String getValueProperty() {
        return this.valueProperty;
    }

    public void setValueProperty(String valueProperty) {
        this.valueProperty = valueProperty;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
        if (StringUtils.isNotEmpty((String)objectName) && StringUtils.isNotEmpty((String)this.keyProperty) && StringUtils.isNotEmpty((String)this.valueProperty)) {
            try {
                String[] keys = StringUtils.splitPreserveAllTokens((String)this.keyProperty, (String)DaoConfig.PROPERTY_SEPARATOR);
                this.keyMethod = new Method[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    this.keyMethod[i] = MethodUtils.getAccessibleMethod(Class.forName(objectName), (String)("get" + WordUtils.capitalize((String)keys[i])), (Class[])new Class[0]);
                }
                this.valueMethod = MethodUtils.getAccessibleMethod(Class.forName(objectName), (String)("get" + WordUtils.capitalize((String)this.valueProperty)), (Class[])new Class[0]);
                if (StringUtils.isBlank((String)this.columnName) && StringUtils.isNotEmpty((String)this.sqlitem)) {
                    String tempCol = StringUtils.substringBetween((String)this.sqlitem, (String)"select", (String)"from");
                    this.columnName = StringUtils.trimToEmpty((String)tempCol);
                }
            }
            catch (ClassNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                logger.error((Object)("class no't find " + this.objectName));
            }
        }
    }

    @Override
    public Method[] getKeyMethod() {
        return this.keyMethod;
    }

    public Method getValueMethod() {
        return this.valueMethod;
    }

    public String getSqlcountitem() {
        if (StringUtils.isBlank((String)this.sqlcountitem) && StringUtils.isNotEmpty((String)this.sqlitem)) {
            String sTemp = this.sqlitem.replace("  ", " ");
            this.sqlcountitem = sTemp.replaceAll("select (.+?) from", "select count($1) from");
        }
        return this.sqlcountitem;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MapItem[");
        buffer.append("columnName = ").append(this.columnName);
        if (this.keyMethod == null) {
            buffer.append(" keyMethod = ").append("null");
        } else {
            buffer.append(" keyMethod = ").append(Arrays.asList(this.keyMethod).toString());
        }
        buffer.append(" keyProperty = ").append(this.keyProperty);
        buffer.append(" name = ").append(this.name);
        buffer.append(" objectName = ").append(this.objectName);
        buffer.append(" sqlcountitem = ").append(this.sqlcountitem);
        buffer.append(" sqlitem = ").append(this.sqlitem);
        buffer.append(" sqlType = ").append(this.sqlType);
        buffer.append(" update = ").append(this.update);
        buffer.append(" valueMethod = ").append(this.valueMethod);
        buffer.append(" valueProperty = ").append(this.valueProperty);
        buffer.append("]");
        return buffer.toString();
    }
}

