/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.sms.impl;

import com.esms.MessageData;
import com.esms.PostMsg;
import com.esms.common.entity.Account;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.gemantic.sms.SmsHandlerTriple;
import com.gemantic.sms.SmsResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsHandlerUMPImpl
implements SmsHandlerTriple {
    private static Log log = LogFactory.getLog(SmsHandlerUMPImpl.class);
    private String userName = "admin";
    private String password = "123456";
    private String sign = "\u3010\u91d1\u6c47\u7406\u8d22\u3011";
    private String cmHost = "114.242.145.106";
    private Integer cmPort = 8090;
    private String wsHost = "114.242.145.106";
    private Integer wsPort = 8088;
    private Account ac;
    private PostMsg pm;

    public void init() {
        this.ac = new Account(this.userName, this.password);
        this.pm = new PostMsg();
        this.pm.getCmHost().setHost(this.cmHost, this.cmPort.intValue());
        this.pm.getWsHost().setHost(this.wsHost, this.wsPort.intValue());
    }

    public static void main(String[] args) throws ServiceException {
    }

    @Override
    public SmsResult sendSimpleMessage(String phone, String msg) throws ServiceException {
        return this.sendMessage(this.sign, "", "", phone, msg);
    }

    @Override
    public SmsResult sendMessage(String sign, String sendtime, String subcode, String phone, String msg) throws ServiceException {
        try {
            MTPack pack = new MTPack();
            pack.setBatchID(UUID.randomUUID());
            if (StringUtils.isBlank((String)sign)) {
                pack.setBatchName(this.sign);
            } else {
                pack.setBatchName(sign);
            }
            pack.setMsgType(MTPack.MsgType.SMS);
            pack.setBizType(0);
            pack.setDistinctFlag(false);
            pack.setSendType(MTPack.SendType.MASS);
            List phones = StringUtil.convertSplitString2UniqueList((String)phone, (String)",");
            if (StringUtils.isBlank((String)msg)) {
                return SmsResult.EmptyConentResult;
            }
            if (CollectionUtils.isEmpty((Collection)phones)) {
                return SmsResult.EmptyPhoneResult;
            }
            String message = msg;
            ArrayList<MessageData> msgs = new ArrayList<MessageData>();
            if (phones.size() == 1) {
                msgs.add(new MessageData((String)phones.get(0), message));
            } else {
                for (String p : phones) {
                    msgs.add(new MessageData(p, message));
                }
            }
            pack.setMsgs(msgs);
            GsmsResponse resp = this.pm.post(this.ac, pack);
            int resultCode = resp.getResult();
            SmsResult rr = SmsResult.getEnum(resultCode);
            if (null != rr) {
                if (rr.getIndex() == 0) {
                    log.info((Object)("successfully send a sms message! seq=" + resp.getUuid() + ",sign=" + sign + ",sendtime=" + sendtime + ",subcode=" + subcode + ",phone=" + phone + ",msg=" + msg));
                } else {
                    log.error((Object)("failure send a sms message! " + rr.toString() + ",phone=" + phone + ",msg=" + msg + " resp " + resp));
                }
                return rr;
            }
            log.error((Object)("sendMessage result unkown  sign=" + sign + ",sendtime=" + sendtime + ",subcode=" + subcode + ",phone=" + phone + ",msg=" + msg + " resp " + resp));
            return SmsResult.UnkownResult;
        }
        catch (Throwable e) {
            log.error((Object)("sendMessage error sign=" + sign + ",sendtime=" + sendtime + ",subcode=" + subcode + ",phone=" + phone + ",msg=" + msg), e);
            e.printStackTrace();
            return SmsResult.NetError;
        }
    }

    @Override
    public SmsResult sendSimpleMessageGroup(List<Pair<String, String>> phoneContentList) throws ServiceException {
        return this.sendMessageGroup(this.sign, "", "", phoneContentList);
    }

    @Override
    public SmsResult sendMessageGroup(String sign, String sendtime, String subcode, List<Pair<String, String>> phoneContentList) throws ServiceException {
        try {
            MTPack pack = new MTPack();
            pack.setBatchID(UUID.randomUUID());
            if (StringUtils.isBlank((String)sign)) {
                pack.setBatchName(this.sign);
            } else {
                pack.setBatchName(sign);
            }
            pack.setMsgType(MTPack.MsgType.SMS);
            pack.setBizType(0);
            pack.setDistinctFlag(false);
            pack.setSendType(MTPack.SendType.GROUP);
            if (CollectionUtils.isEmpty(phoneContentList)) {
                return SmsResult.EmptyPhoneResult;
            }
            ArrayList<MessageData> msgs = new ArrayList<MessageData>();
            for (Pair<String, String> p_c : phoneContentList) {
                msgs.add(new MessageData((String)p_c.getLeft(), (String)p_c.getRight()));
            }
            pack.setMsgs(msgs);
            GsmsResponse resp = this.pm.post(this.ac, pack);
            int resultCode = resp.getResult();
            SmsResult rr = SmsResult.getEnum(resultCode);
            if (null != rr) {
                if (rr.getIndex() == 0) {
                    log.info((Object)("successfully send a sms message! seq=" + resp.getUuid() + ",sign=" + sign + ",sendtime=" + sendtime + ",subcode=" + subcode + "," + phoneContentList));
                } else {
                    log.error((Object)("failure send a sms message! " + rr.toString() + "," + phoneContentList + "," + " resp " + resp));
                }
                return rr;
            }
            log.error((Object)("sendMessage result unkown  sign=" + sign + ",sendtime=" + sendtime + ",subcode=" + subcode + "," + phoneContentList + " resp " + resp));
            return SmsResult.UnkownResult;
        }
        catch (Throwable e) {
            log.error((Object)("sendMessage error sign=" + sign + ",sendtime=" + sendtime + "," + phoneContentList), e);
            e.printStackTrace();
            return SmsResult.NetError;
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setCmHost(String cmHost) {
        this.cmHost = cmHost;
    }

    public void setCmPort(Integer cmPort) {
        this.cmPort = cmPort;
    }

    public void setWsHost(String wsHost) {
        this.wsHost = wsHost;
    }

    public void setWsPort(Integer wsPort) {
        this.wsPort = wsPort;
    }
}

