/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.sms.impl;

import com.gemantic.common.exception.ServiceException;
import com.gemantic.sms.SmsHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.springframework.beans.factory.annotation.Required;

public class SmsHandlerSpread
implements SmsHandler {
    private static Log log = LogFactory.getLog(SmsHandlerSpread.class);
    private String url;
    private String userName;
    private String passWord;
    private String productId;

    public String getUrl() {
        return this.url;
    }

    @Required
    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    @Required
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    @Required
    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getProductId() {
        return this.productId;
    }

    @Required
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public boolean sendMessage(String methodName, String phoneList, String msg) throws ServiceException {
        Client client = null;
        Object[] replys = null;
        if (!StringUtils.isBlank((String)phoneList) && phoneList.split(",").length > 100) {
            throw new ServiceException("the count of phoneList can not above 100");
        }
        if (StringUtils.isBlank((String)methodName) || StringUtils.isBlank((String)phoneList) || StringUtils.isBlank((String)msg)) {
            throw new ServiceException("params has null");
        }
        try {
            client = this.getClient();
            if (client == null) {
                throw new ServiceException("can not connect sms WebService");
            }
            replys = client.invoke(methodName, new Object[]{this.userName, this.passWord, this.productId, phoneList, msg, ""});
        }
        catch (Exception e) {
            log.error((Object)("send sms error:" + e));
            throw new ServiceException("got error when send sms.", (Throwable)e);
        }
        if (replys == null) {
            throw new ServiceException("call webservice no return value");
        }
        if (replys != null && replys.length == 0) {
            throw new ServiceException("call webservice no return value");
        }
        if (!replys[0].toString().contains("|") || replys[0].toString().contains("-")) {
            log.error((Object)("send sms error:" + replys[0].toString()));
            throw new ServiceException("error code:" + replys[0]);
        }
        return true;
    }

    private Client getClient() {
        DynamicClientFactory dcf = DynamicClientFactory.newInstance();
        return dcf.createClient(this.url);
    }
}

