/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.sms.impl;

import com.gemantic.common.exception.ServiceException;
import com.gemantic.sms.MsgBean;
import com.gemantic.sms.SmsHandlerMQ;
import java.util.UUID;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.spring.ActiveMQConnectionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class SmsHandlerMQImpl
implements SmsHandlerMQ {
    private static Log log = LogFactory.getLog(SmsHandlerMQImpl.class);
    private String url;
    private String queueName;
    private String userName;
    private String passWord;
    private JmsTemplate jmsTemplate;
    private ActiveMQQueue destination;

    public String getUrl() {
        return this.url;
    }

    @Required
    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    @Required
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    @Required
    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Required
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public void init() {
        try {
            if (null == this.jmsTemplate) {
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
                connectionFactory.setBrokerURL(this.url);
                connectionFactory.setUserName(this.userName);
                connectionFactory.setPassword(this.passWord);
                this.jmsTemplate = new JmsTemplate((ConnectionFactory)connectionFactory);
                this.jmsTemplate.setDeliveryMode(1);
                this.jmsTemplate.setSessionAcknowledgeMode(1);
            }
            if (null == this.destination) {
                this.destination = new ActiveMQQueue(this.queueName);
            }
        }
        catch (Exception e) {
            log.error((Object)"SmsHandlerMQImpl init error", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public boolean sendMessage(String phone, String msg) throws ServiceException {
        if (StringUtils.isBlank((String)phone) || StringUtils.isBlank((String)msg)) {
            throw new ServiceException("params has null");
        }
        if (null == this.jmsTemplate || null == this.destination) {
            this.init();
        }
        try {
            String seq = UUID.randomUUID().toString();
            final MsgBean msgg = new MsgBean(seq, phone, msg, "1");
            this.jmsTemplate.send((Destination)this.destination, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    TextMessage message = session.createTextMessage(msgg.toString());
                    message.setJMSDeliveryMode(1);
                    return message;
                }
            });
            log.info((Object)("successfully send a sms message!phone=" + phone + ";seq=" + seq + ";msg=" + msg));
        }
        catch (Exception e) {
            log.error((Object)("send sms error,phone=" + phone + ",msg=" + msg + ":" + e));
            throw new ServiceException("got error when send sms.", (Throwable)e);
        }
        return true;
    }
}

