/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.sms.impl;

import com.gemantic.common.exception.ServiceException;
import com.gemantic.sms.SmsHandler;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.springframework.beans.factory.annotation.Required;

public class SmsHandlerHC
implements SmsHandler {
    private static Log log = LogFactory.getLog(SmsHandlerHC.class);
    private static final AtomicInteger count = new AtomicInteger(0);
    private Integer okCode = 1;
    private String url;
    private String userName;
    private String passWord;
    private String eCode;
    private String extNo;
    private String seq;
    private String sendTime = null;
    private String task = null;

    public String getUrl() {
        return this.url;
    }

    @Required
    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    @Required
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    @Required
    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String geteCode() {
        return this.eCode;
    }

    @Required
    public void seteCode(String eCode) {
        this.eCode = eCode;
    }

    public String getExtNo() {
        return this.extNo;
    }

    public void setExtNo(String extNo) {
        this.extNo = extNo;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    @Override
    public boolean sendMessage(String methodName, String phoneList, String msg) throws ServiceException {
        Client client = null;
        Object[] replys = null;
        if (!StringUtils.isBlank((String)phoneList) && phoneList.split(",").length > 100) {
            throw new ServiceException("the count of phoneList can not above 100");
        }
        if (StringUtils.isBlank((String)methodName) || StringUtils.isBlank((String)phoneList) || StringUtils.isBlank((String)msg)) {
            throw new ServiceException("params has null");
        }
        try {
            client = this.getClient();
            if (client == null) {
                throw new ServiceException("can not connect sms WebService");
            }
            if (count.intValue() > 999999) {
                count.set(0);
            }
            this.seq = String.valueOf(count.getAndIncrement());
            replys = client.invoke(methodName, new Object[]{this.eCode, this.extNo, this.userName, this.passWord, phoneList, msg, this.seq, this.sendTime, this.task});
            log.info((Object)("successfully send a sms message,seq=" + this.seq));
        }
        catch (Exception e) {
            log.error((Object)("send sms error:" + e));
            throw new ServiceException("got error when send sms.", (Throwable)e);
        }
        if (replys == null) {
            throw new ServiceException("call webservice no return value");
        }
        if (replys != null && replys.length == 0) {
            throw new ServiceException("call webservice no return value");
        }
        if (!replys[0].toString().equals(this.okCode.toString())) {
            log.error((Object)("send sms error:" + replys[0].toString()));
            throw new ServiceException("error code:" + replys[0]);
        }
        return true;
    }

    private Client getClient() {
        DynamicClientFactory dcf = DynamicClientFactory.newInstance();
        return dcf.createClient(this.url);
    }
}

