/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.utils;

import java.beans.ConstructorProperties;

public class Pair<L, R> {
    private L left;
    private R right;

    public static <L, R> PairBuilder<L, R> builder() {
        return new PairBuilder();
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public void setRight(R right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        L this$left = this.getLeft();
        L other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        R this$right = this.getRight();
        R other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        L $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        R $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "Pair(left=" + this.getLeft() + ", right=" + this.getRight() + ")";
    }

    public Pair() {
    }

    @ConstructorProperties(value={"left", "right"})
    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static class PairBuilder<L, R> {
        private L left;
        private R right;

        PairBuilder() {
        }

        public PairBuilder<L, R> left(L left) {
            this.left = left;
            return this;
        }

        public PairBuilder<L, R> right(R right) {
            this.right = right;
            return this;
        }

        public Pair<L, R> build() {
            return new Pair<L, R>(this.left, this.right);
        }

        public String toString() {
            return "Pair.PairBuilder(left=" + this.left + ", right=" + this.right + ")";
        }
    }
}

