/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.core;

import com.blade.jdbc.Base;
import com.blade.jdbc.annotation.Column;
import com.blade.jdbc.annotation.Transient;
import com.blade.jdbc.core.ActiveRecord;
import com.blade.jdbc.core.ConditionEnum;
import com.blade.jdbc.core.Fields;
import com.blade.jdbc.core.OrderBy;
import com.blade.jdbc.core.QueryMeta;
import com.blade.jdbc.page.PageRow;
import com.blade.jdbc.utils.NameUtils;
import com.blade.jdbc.utils.Pair;
import com.blade.jdbc.utils.StringUtils;
import com.blade.jdbc.utils.Unchecked;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SqlBuilder {
    SqlBuilder() {
    }

    static QueryMeta buildInsertSql(ActiveRecord activeRecord) {
        QueryMeta queryMeta = new QueryMeta();
        String tableName = activeRecord.getTableName();
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(tableName);
        sb.append(" (");
        StringBuffer values = new StringBuffer(" values (");
        Stream.of(activeRecord.getClass().getDeclaredFields()).filter(field -> null == field.getAnnotation(Transient.class)).forEach(field -> {
            try {
                field.setAccessible(true);
                if (field.get(activeRecord) != null) {
                    Pair<String, String> pair = SqlBuilder.getColumnName(field);
                    sb.append(pair.getLeft()).append(", ");
                    values.append(':').append(pair.getRight()).append(", ");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        sb.append(')');
        values.append(')');
        String sql = sb.append(values).toString().replace(", )", ")");
        queryMeta.setSql(sql);
        return queryMeta;
    }

    static QueryMeta buildUpdateSql(ActiveRecord activeRecord) {
        QueryMeta queryMeta = new QueryMeta();
        String tableName = activeRecord.getTableName();
        StringBuilder sb = new StringBuilder("update ");
        sb.append(tableName);
        sb.append(" set ");
        int[] pos = new int[]{1};
        List<Object> list = SqlBuilder.parseSet(activeRecord, pos, sb);
        sb.append("where ");
        activeRecord.whereValues.forEach(where -> {
            int n = pos[0];
            pos[0] = n + 1;
            sb.append(where.getKey()).append(" ").append(where.getOpt()).append(" ").append(":p").append(n).append(" and ");
            list.add(where.getValue());
        });
        String sql = sb.toString().replace(", where ", " where ").replace("and  or", "or");
        if (sql.endsWith("and ")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        Object[] args = list.toArray();
        queryMeta.setParams(args);
        queryMeta.setSql(sql);
        return queryMeta;
    }

    static QueryMeta buildFindSql(ActiveRecord activeRecord) {
        QueryMeta queryMeta = new QueryMeta();
        String initSql = SqlBuilder.parseFieldsSql(activeRecord.getTableName(), null);
        StringBuilder sqlBuf = new StringBuilder(initSql);
        int[] pos = new int[]{1};
        List<Object> list = SqlBuilder.parseWhere(activeRecord, pos, sqlBuf);
        List<Object> temp = SqlBuilder.andWhere(activeRecord, pos, sqlBuf);
        if (null != temp) {
            list.addAll(temp);
        }
        String sql = SqlBuilder.sqlFilter(sqlBuf.toString());
        queryMeta.setSql(sql);
        queryMeta.setParams(list.toArray());
        SqlBuilder.mapping(queryMeta, activeRecord.getClass());
        return queryMeta;
    }

    @SafeVarargs
    static QueryMeta buildFindAllSql(ActiveRecord activeRecord, Supplier<ConditionEnum> ... conditions) {
        PageRow pageRow;
        String limit;
        QueryMeta queryMeta = new QueryMeta();
        String initSql = SqlBuilder.parseFieldsSql(activeRecord.getTableName(), conditions);
        StringBuilder sqlBuf = new StringBuilder(initSql);
        int[] pos = new int[]{1};
        List<Object> list = SqlBuilder.parseWhere(activeRecord, pos, sqlBuf);
        List<Object> temp = SqlBuilder.andWhere(activeRecord, pos, sqlBuf);
        if (null != temp) {
            list.addAll(temp);
        }
        String sql = SqlBuilder.sqlFilter(sqlBuf.toString());
        String orderBy = SqlBuilder.parseOrderBySql(conditions);
        if (null != orderBy) {
            sql = sql + orderBy;
        }
        if (null != (limit = SqlBuilder.appendLimit(pageRow = Base.pageLocal.get()))) {
            sql = sql + limit;
        }
        Object[] args = list.toArray();
        queryMeta.setSql(sql);
        queryMeta.setParams(args);
        SqlBuilder.mapping(queryMeta, activeRecord.getClass());
        return queryMeta;
    }

    static QueryMeta buildCountSql(ActiveRecord activeRecord) {
        QueryMeta queryMeta = new QueryMeta();
        StringBuilder sqlBuf = new StringBuilder("select count(*) from " + activeRecord.getTableName());
        int[] pos = new int[]{1};
        List<Object> list = SqlBuilder.parseWhere(activeRecord, pos, sqlBuf);
        List<Object> temp = SqlBuilder.andWhere(activeRecord, pos, sqlBuf);
        if (null != temp) {
            list.addAll(temp);
        }
        String sql = SqlBuilder.sqlFilter(sqlBuf.toString());
        Object[] args = list.toArray();
        queryMeta.setSql(sql);
        queryMeta.setParams(args);
        return queryMeta;
    }

    static QueryMeta buildDeleteSql(ActiveRecord activeRecord) {
        List<Object> temp;
        QueryMeta queryMeta = new QueryMeta();
        StringBuilder sqlBuf = new StringBuilder("delete from " + activeRecord.getTableName());
        int[] pos = new int[]{1};
        List<Object> list = SqlBuilder.parseWhere(activeRecord, pos, sqlBuf);
        if (activeRecord.whereValues.isEmpty()) {
            throw new RuntimeException("Delete operation must take conditions.");
        }
        if (sqlBuf.indexOf(" where ") == -1) {
            sqlBuf.append(" where ");
        }
        if (null != (temp = SqlBuilder.andWhere(activeRecord, pos, sqlBuf))) {
            list.addAll(temp);
        }
        String sql = sqlBuf.toString();
        if ((sql = sql.replace(", where", " where").replace("and  or", "or")).endsWith("and ")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        Object[] args = list.toArray();
        queryMeta.setSql(sql);
        queryMeta.setParams(args);
        return queryMeta;
    }

    private static List<Object> andWhere(ActiveRecord activeRecord, int[] pos, StringBuilder sqlBuf) {
        if (!activeRecord.whereValues.isEmpty()) {
            if (sqlBuf.indexOf(" where ") == -1) {
                sqlBuf.append(" where ");
            }
            return activeRecord.whereValues.stream().map(where -> {
                int n = pos[0];
                pos[0] = n + 1;
                sqlBuf.append(where.getKey()).append(" ").append(where.getOpt()).append(" ").append(":p").append(n).append(" and ");
                return where.getValue();
            }).collect(Collectors.toList());
        }
        return null;
    }

    private static List<Object> parseWhere(ActiveRecord activeRecord, int[] pos, StringBuilder sqlBuf) {
        return Stream.of(activeRecord.getClass().getDeclaredFields()).filter(field -> Objects.isNull(field.getAnnotation(Transient.class))).filter(field -> null != Unchecked.wrap(() -> {
            field.setAccessible(true);
            return field.get(activeRecord);
        })).map(field -> Unchecked.wrap(() -> {
            if (sqlBuf.indexOf(" where ") == -1) {
                sqlBuf.append(" where ");
            }
            Object value = field.get(activeRecord);
            Pair<String, String> pair = SqlBuilder.getColumnName(field);
            int n = pos[0];
            pos[0] = n + 1;
            sqlBuf.append(pair.getRight()).append(" = ").append(":p").append(n).append(" and ");
            return value;
        })).collect(Collectors.toList());
    }

    private static String parseFieldsSql(String tableName, Supplier<ConditionEnum>[] conditions) {
        String[] sql = new String[]{"select * from " + tableName};
        if (null == conditions) {
            return sql[0];
        }
        Stream.of(conditions).filter(conditionEnumSupplier -> ((ConditionEnum)((Object)((Object)conditionEnumSupplier.get()))).equals((Object)ConditionEnum.FIELDS)).findFirst().ifPresent(conditionEnumSupplier -> {
            Fields fields = (Fields)conditionEnumSupplier;
            Set<String> fieldsSet = fields.getFields();
            sql[0] = "select " + fieldsSet.stream().collect(Collectors.joining(",")) + " from " + tableName;
        });
        return sql[0];
    }

    private static String sqlFilter(String sql) {
        if ((sql = sql.replace(", where", " where").replace("and  or", "or")).endsWith(" and ")) {
            sql = sql.substring(0, sql.length() - 5);
        }
        if (sql.endsWith(", ")) {
            sql = sql.substring(0, sql.length() - 2);
        }
        return sql;
    }

    public static String appendLimit(PageRow pageRow) {
        if (null == pageRow) {
            return null;
        }
        return String.format(" limit %s, %s", pageRow.getOffset(), pageRow.getLimit());
    }

    private static String parseOrderBySql(Supplier<ConditionEnum>[] conditions) {
        String[] sql = new String[]{null};
        if (null == conditions) {
            return sql[0];
        }
        Stream.of(conditions).filter(conditionEnumSupplier -> ((ConditionEnum)((Object)((Object)conditionEnumSupplier.get()))).equals((Object)ConditionEnum.ORDER_BY)).findFirst().ifPresent(conditionEnumSupplier -> {
            OrderBy orderBy = (OrderBy)conditionEnumSupplier;
            sql[0] = " order by " + orderBy.getOrderBy();
        });
        return sql[0];
    }

    private static List<Object> parseSet(ActiveRecord activeRecord, int[] pos, StringBuilder sqlBuf) {
        return Stream.of(activeRecord.getClass().getDeclaredFields()).filter(field -> null == field.getAnnotation(Transient.class)).filter(field -> null != Unchecked.wrap(() -> {
            field.setAccessible(true);
            return field.get(activeRecord);
        })).map(field -> Unchecked.wrap(() -> {
            Object value = field.get(activeRecord);
            Pair<String, String> pair = SqlBuilder.getColumnName(field);
            int n = pos[0];
            pos[0] = n + 1;
            sqlBuf.append(pair.getLeft()).append(" = ").append(":p").append(n).append(", ");
            return value;
        })).collect(Collectors.toList());
    }

    private static Pair<String, String> getColumnName(Field field) {
        String fieldName = field.getName();
        Column column = field.getAnnotation(Column.class);
        if (null != column && StringUtils.isNotBlank(column.name())) {
            fieldName = column.name();
        }
        String columnName = NameUtils.getUnderlineName(fieldName);
        return new Pair<String, String>(columnName, fieldName);
    }

    public static void mapping(QueryMeta queryMeta, Class<?> modelType) {
        Stream.of(modelType.getDeclaredFields()).filter(field -> null == field.getAnnotation(Transient.class)).forEach(field -> {
            Pair<String, String> pair = SqlBuilder.getColumnName(field);
            if (!pair.getLeft().equals(pair.getRight())) {
                queryMeta.addColumnMapping(pair.getLeft(), pair.getRight());
            }
        });
    }
}

