/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class QueryMeta {
    private String sql;
    private Object[] params;
    private Map<String, String> columnMapping;

    public QueryMeta(String sql, Object[] params) {
        this.sql = sql;
        this.params = params;
    }

    public void addColumnMapping(String columnName, String fieldName) {
        if (null == this.columnMapping) {
            this.columnMapping = new HashMap<String, String>(8);
        }
        this.columnMapping.put(columnName, fieldName);
    }

    public boolean hasColumnMapping() {
        return null != this.columnMapping && !this.columnMapping.isEmpty();
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Map<String, String> getColumnMapping() {
        return this.columnMapping;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public void setColumnMapping(Map<String, String> columnMapping) {
        this.columnMapping = columnMapping;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryMeta)) {
            return false;
        }
        QueryMeta other = (QueryMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getParams(), other.getParams())) {
            return false;
        }
        Map<String, String> this$columnMapping = this.getColumnMapping();
        Map<String, String> other$columnMapping = other.getColumnMapping();
        return !(this$columnMapping == null ? other$columnMapping != null : !((Object)this$columnMapping).equals(other$columnMapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParams());
        Map<String, String> $columnMapping = this.getColumnMapping();
        result = result * 59 + ($columnMapping == null ? 43 : ((Object)$columnMapping).hashCode());
        return result;
    }

    public String toString() {
        return "QueryMeta(sql=" + this.getSql() + ", params=" + Arrays.deepToString(this.getParams()) + ", columnMapping=" + this.getColumnMapping() + ")";
    }

    public QueryMeta() {
    }
}

