/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc.core;

import com.blade.jdbc.Base;
import com.blade.jdbc.annotation.Table;
import com.blade.jdbc.annotation.Transient;
import com.blade.jdbc.core.ConditionEnum;
import com.blade.jdbc.core.QueryMeta;
import com.blade.jdbc.core.SqlBuilder;
import com.blade.jdbc.core.WhereParam;
import com.blade.jdbc.page.Page;
import com.blade.jdbc.page.PageRow;
import com.blade.jdbc.utils.Unchecked;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Query;
import org.sql2o.Sql2o;

public class ActiveRecord
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ActiveRecord.class);
    private static final String EXECUTE_SQL_PREFIX = "\u2b22 Execute SQL";
    private static final String PARAMETER_PREFIX = "\u2b22 Parameters ";
    @Transient
    protected Sql2o sql2o;
    @Transient
    Set<WhereParam> whereValues = new LinkedHashSet<WhereParam>();
    @Transient
    private Set<String> saveOrUpdateProperties = new TreeSet<String>();

    public Sql2o getSql2o() {
        if (null != this.sql2o) {
            return this.sql2o;
        }
        return Base.sql2o;
    }

    public <T extends ActiveRecord> T where(String key, Object value) {
        return this.where(key, "=", value);
    }

    public <T extends ActiveRecord> T where(String key, String opt, Object value) {
        this.whereValues.add(WhereParam.builder().key(key).opt(opt).value(value).build());
        this.saveOrUpdateProperties.add(key);
        return (T)this;
    }

    public <T extends ActiveRecord> T like(String key, Object value) {
        return this.where(key, "like", value);
    }

    public <T extends ActiveRecord> T and(String key, Object value) {
        return this.where(key, value);
    }

    public <T extends ActiveRecord> T and(String key, String opt, Object value) {
        return this.where(key, opt, value);
    }

    public <T extends ActiveRecord> T or(String key, Object value) {
        return this.or(key, "=", value);
    }

    public <T extends ActiveRecord> T or(String key, String opt, Object value) {
        return this.where(" or " + key, opt, value);
    }

    public <T extends ActiveRecord, V> T in(String key, List<V> list) {
        return this.where(key, "in", "(" + list.stream().map(Object::toString).collect(Collectors.joining(",")) + ")");
    }

    public <T extends ActiveRecord> T between(String key, Object val1, Object val2) {
        this.whereValues.add(WhereParam.builder().key(key).opt("between").value(val1).build());
        this.saveOrUpdateProperties.add(key);
        return (T)this;
    }

    public <S extends Serializable> S save() {
        QueryMeta queryMeta = SqlBuilder.buildInsertSql(this);
        try (Connection con = this.getConn();){
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            Serializable serializable = (Serializable)con.createQuery(queryMeta.getSql()).bind((Object)this).executeUpdate().getKey();
            return (S)serializable;
        }
    }

    public void update(Serializable pk) {
        this.update(this.getPk(), pk);
    }

    public void update(String field, Object value) {
        this.whereValues.add(WhereParam.builder().key(field).opt("=").value(value).build());
        this.update();
    }

    public int update() {
        QueryMeta queryMeta = SqlBuilder.buildUpdateSql(this);
        int result = this.invoke(queryMeta);
        this.cleanParam();
        return result;
    }

    public void execute(String sql, Object ... params) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        this.invoke(new QueryMeta(sql, params));
    }

    private int invoke(QueryMeta queryMeta) {
        log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
        log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
        if (null == Base.connectionThreadLocal.get()) {
            try (Connection con = this.getSql2o().open();){
                Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams());
                if (queryMeta.hasColumnMapping()) {
                    queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
                }
                int n = query.executeUpdate().getResult();
                return n;
            }
        }
        try (Connection con = this.getConn();){
            Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams());
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            int n = query.executeUpdate().getResult();
            return n;
        }
    }

    private Connection getConn() {
        return null != Base.connectionThreadLocal.get() ? Base.connectionThreadLocal.get() : this.getSql2o().open();
    }

    public <T> T query(String sql, Object ... args) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        Class<?> type = this.getClass();
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(args));
            Object object = con.createQuery(sql).withParams(args).executeAndFetchFirst(type);
            return (T)object;
        }
    }

    public <T> List<T> queryAll(String sql, Object ... args) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        PageRow pageRow = Base.pageLocal.get();
        String limit = SqlBuilder.appendLimit(pageRow);
        if (null != limit) {
            sql = sql + limit;
        }
        Class<?> type = this.getClass();
        args = args == null ? new Object[]{} : args;
        try (Connection con = this.getSql2o().open();){
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(args));
            Query query = con.createQuery(sql).withParams(args);
            QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, null);
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            this.cleanParam();
            List list = query.executeAndFetch(type);
            return list;
        }
    }

    public <T extends ActiveRecord> List<T> findAll() {
        return this.findAll(null);
    }

    public <T extends ActiveRecord> List<T> findAll(Supplier<ConditionEnum> ... conditions) {
        QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, conditions);
        Class<?> type = this.getClass();
        try (Connection con = this.getSql2o().open();){
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
            Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams());
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            this.cleanParam();
            List list = query.executeAndFetch(type);
            return list;
        }
    }

    public <T extends ActiveRecord> Page<T> page(int page, int limit) {
        return this.page(page, limit, null);
    }

    public <T extends ActiveRecord> Page<T> page(int page, int limit, String orderBy) {
        return this.page(new PageRow(page, limit), orderBy);
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow) {
        return this.page(pageRow, null);
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow, String orderBy) {
        QueryMeta queryMeta = SqlBuilder.buildFindAllSql(this, null);
        return this.page(pageRow, queryMeta.getSql(), orderBy, queryMeta.getParams());
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow, String sql, Object ... params) {
        return this.page(pageRow, sql, null, params);
    }

    public <T extends ActiveRecord> Page<T> page(PageRow pageRow, String sql, String orderBy, Object ... params) {
        Base.pageLocal.set(pageRow);
        int page = pageRow.getPage();
        int limit = pageRow.getLimit();
        if (null != sql) {
            int pos = 1;
            while (sql.indexOf("?") != -1) {
                sql = sql.replaceFirst("\\?", ":p" + pos++);
            }
        } else {
            sql = "select * from " + this.getTableName();
        }
        String countSql = "select count(0) from (" + sql + ") tmp";
        long count = this.count(countSql, params);
        if (null != orderBy) {
            sql = sql + " order by " + orderBy;
        }
        List<T> list = this.queryAll(sql, params);
        Page<T> pageBean = new Page<T>(count, page, limit);
        pageBean.setRows(list);
        Base.pageLocal.remove();
        return pageBean;
    }

    public <T extends ActiveRecord> T find() {
        QueryMeta queryMeta = SqlBuilder.buildFindSql(this);
        Class<?> type = this.getClass();
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
            Query query = con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams());
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            ActiveRecord activeRecord = (ActiveRecord)query.executeAndFetchFirst(type);
            return (T)activeRecord;
        }
    }

    public <T extends ActiveRecord> T find(Serializable id) {
        String sql = "select * from " + this.getTableName() + " where " + this.getPk() + " = :p1";
        QueryMeta queryMeta = new QueryMeta();
        SqlBuilder.mapping(queryMeta, this.getClass());
        Class<?> type = this.getClass();
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => [{}]", (Object)id);
            Query query = con.createQuery(sql).withParams(new Object[]{id});
            if (queryMeta.hasColumnMapping()) {
                queryMeta.getColumnMapping().forEach((arg_0, arg_1) -> ((Query)query).addColumnMapping(arg_0, arg_1));
            }
            ActiveRecord activeRecord = (ActiveRecord)query.executeAndFetchFirst(type);
            return (T)activeRecord;
        }
    }

    private long count(boolean cleanParam) {
        QueryMeta queryMeta = SqlBuilder.buildCountSql(this);
        try (Connection con = this.getSql2o().open();){
            if (cleanParam) {
                this.cleanParam();
            }
            log.debug("\u2b22 Execute SQL => {}", (Object)queryMeta.getSql());
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(queryMeta.getParams()));
            long l = (Long)con.createQuery(queryMeta.getSql()).withParams(queryMeta.getParams()).executeAndFetchFirst(Long.class);
            return l;
        }
    }

    public long count() {
        return this.count(true);
    }

    public long count(String sql, Object ... args) {
        int pos = 1;
        while (sql.indexOf("?") != -1) {
            sql = sql.replaceFirst("\\?", ":p" + pos++);
        }
        args = args == null ? new Object[]{} : args;
        try (Connection con = this.getSql2o().open();){
            this.cleanParam();
            log.debug("\u2b22 Execute SQL => {}", (Object)sql);
            log.debug("\u2b22 Parameters  => {}", (Object)Arrays.toString(args));
            long l = (Long)con.createQuery(sql).withParams(args).executeAndFetchFirst(Long.class);
            return l;
        }
    }

    String getTableName() {
        Class<?> modelType = this.getClass();
        Table table = modelType.getAnnotation(Table.class);
        if (null != table) {
            return table.value().toLowerCase();
        }
        return modelType.getSimpleName().toLowerCase();
    }

    private String getPk() {
        Class<?> modelType = this.getClass();
        Table table = modelType.getAnnotation(Table.class);
        if (null != table) {
            return table.pk().toLowerCase();
        }
        return "id";
    }

    public void delete() {
        QueryMeta queryMeta = SqlBuilder.buildDeleteSql(this);
        this.invoke(queryMeta);
        this.cleanParam();
    }

    public void delete(Serializable pk) {
        this.delete(this.getPk(), pk);
    }

    public void delete(String field, Object value) {
        this.whereValues.add(WhereParam.builder().key(field).opt("=").value(value).build());
        this.delete();
    }

    private void cleanParam() {
        this.whereValues.clear();
        this.saveOrUpdateProperties.clear();
        Stream.of(this.getClass().getDeclaredFields()).filter(field -> Objects.isNull(field.getAnnotation(Transient.class))).forEach(field -> Unchecked.wrap(() -> {
            field.setAccessible(true);
            field.set(this, null);
            return null;
        }));
    }

    public void setSql2o(Sql2o sql2o) {
        this.sql2o = sql2o;
    }
}

