/*
 * Decompiled with CFR 0.152.
 */
package com.blade.jdbc;

import com.blade.jdbc.page.PageRow;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

public final class Base {
    private static final Logger log = LoggerFactory.getLogger(Base.class);
    public static final ThreadLocal<PageRow> pageLocal = new ThreadLocal();
    public static final ThreadLocal<Connection> connectionThreadLocal = new ThreadLocal();
    public static Sql2o sql2o;

    public static Sql2o open(String url, String user, String password) {
        sql2o = new Sql2o(url, user, password);
        log.info("\u2b22 Blade-JDBC initializing");
        return sql2o;
    }

    public static Sql2o open(DataSource dataSource) {
        sql2o = new Sql2o(dataSource);
        log.info("\u2b22 Blade-JDBC initializing");
        return sql2o;
    }

    public static Sql2o open(Sql2o sql2o_) {
        sql2o = sql2o_;
        log.info("\u2b22 Blade-JDBC initializing");
        return sql2o;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T atomic(Supplier<T> supplier) {
        T result = null;
        try {
            block14: {
                Connection con;
                block15: {
                    connectionThreadLocal.remove();
                    connectionThreadLocal.set(sql2o.beginTransaction());
                    con = connectionThreadLocal.get();
                    Throwable throwable = null;
                    try {
                        result = supplier.get();
                        con.commit();
                        if (con == null) break block14;
                        if (throwable == null) break block15;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (con == null) throw throwable4;
                            if (throwable == null) {
                                con.close();
                                throw throwable4;
                            }
                            try {
                                con.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    try {
                        con.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                con.close();
            }
        }
        catch (RuntimeException e) {
            log.info("Transaction rollback");
            connectionThreadLocal.get().rollback();
            throw e;
        }
        finally {
            connectionThreadLocal.remove();
            return result;
        }
    }
}

