/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import com.baomidou.mybatisplus.enums.DBType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.IDialect;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.baomidou.mybatisplus.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.H2Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.HSQLDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.plugins.pagination.dialects.SQLiteDialect;
import com.baomidou.mybatisplus.toolkit.StringUtils;

public class DialectFactory {
    public static String buildPaginationSql(Pagination page, String buildSql, String dialectType, String dialectClazz) throws Exception {
        return DialectFactory.getiDialect(dialectType, dialectClazz).buildPaginationSql(buildSql, page.getOffset(), page.getLimit());
    }

    private static IDialect getiDialect(String dialectType, String dialectClazz) throws Exception {
        IDialect dialect = null;
        if (StringUtils.isNotEmpty(dialectType)) {
            dialect = DialectFactory.getDialectByDbtype(dialectType);
        } else if (StringUtils.isNotEmpty(dialectClazz)) {
            try {
                Class<?> clazz = Class.forName(dialectClazz);
                if (IDialect.class.isAssignableFrom(clazz)) {
                    dialect = (IDialect)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                throw new MybatisPlusException("Class :" + dialectClazz + " is not found");
            }
        }
        if (dialect == null) {
            throw new MybatisPlusException("The value of the dialect property in mybatis configuration.xml is not defined.");
        }
        return dialect;
    }

    private static IDialect getDialectByDbtype(String dbtype) throws Exception {
        IDialect dialect = null;
        if (DBType.MYSQL.getDb().equalsIgnoreCase(dbtype)) {
            dialect = MySqlDialect.INSTANCE;
        } else if (DBType.ORACLE.getDb().equalsIgnoreCase(dbtype)) {
            dialect = OracleDialect.INSTANCE;
        } else if (DBType.DB2.getDb().equalsIgnoreCase(dbtype)) {
            dialect = DB2Dialect.INSTANCE;
        } else if (DBType.H2.getDb().equalsIgnoreCase(dbtype)) {
            dialect = H2Dialect.INSTANCE;
        } else if (DBType.SQLSERVER.getDb().equalsIgnoreCase(dbtype)) {
            dialect = SQLServerDialect.INSTANCE;
        } else if (DBType.SQLSERVER2005.getDb().equalsIgnoreCase(dbtype)) {
            dialect = SQLServer2005Dialect.INSTANCE;
        } else if (DBType.POSTGRE.getDb().equalsIgnoreCase(dbtype)) {
            dialect = PostgreDialect.INSTANCE;
        } else if (DBType.HSQL.getDb().equalsIgnoreCase(dbtype)) {
            dialect = HSQLDialect.INSTANCE;
        } else if (DBType.SQLITE.getDb().equalsIgnoreCase(dbtype)) {
            dialect = SQLiteDialect.INSTANCE;
        } else {
            throw new MybatisPlusException("The database is not supported\uff01dbtype:" + dbtype);
        }
        return dialect;
    }
}

