/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kaptcha;

import com.baomidou.kaptcha.Kaptcha;
import com.baomidou.kaptcha.exception.KaptchaIncorrectException;
import com.baomidou.kaptcha.exception.KaptchaNotFoundException;
import com.baomidou.kaptcha.exception.KaptchaRenderException;
import com.baomidou.kaptcha.exception.KaptchaTimeoutException;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleKaptcha
implements Kaptcha {
    private static final Logger log = LoggerFactory.getLogger(GoogleKaptcha.class);
    private DefaultKaptcha kaptcha;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;

    public GoogleKaptcha(DefaultKaptcha kaptcha) {
        this.kaptcha = kaptcha;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String render() {
        this.response.setDateHeader("Expires", 0L);
        this.response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        this.response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setContentType("image/jpeg");
        String text = this.kaptcha.createText();
        try (ServletOutputStream out = this.response.getOutputStream();){
            this.request.getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)text);
            this.request.getSession().setAttribute("KAPTCHA_SESSION_DATE", (Object)Instant.now());
            ImageIO.write((RenderedImage)this.kaptcha.createImage(text), "jpg", (OutputStream)out);
            String string = text;
            return string;
        }
        catch (IOException e) {
            throw new KaptchaRenderException(e);
        }
    }

    @Override
    public boolean validate(String code) {
        return this.validate(code, 900L);
    }

    @Override
    public boolean validate(String code, long second) {
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null) {
            String sessionCode = (String)httpSession.getAttribute("KAPTCHA_SESSION_KEY");
            if (sessionCode.equalsIgnoreCase(code)) {
                Instant instant = (Instant)httpSession.getAttribute("KAPTCHA_SESSION_DATE");
                long duration = Duration.between(instant, Instant.now()).getSeconds();
                if (duration < second) {
                    httpSession.removeAttribute("KAPTCHA_SESSION_KEY");
                    httpSession.removeAttribute("KAPTCHA_SESSION_DATE");
                    return true;
                }
                throw new KaptchaTimeoutException();
            }
            throw new KaptchaIncorrectException();
        }
        throw new KaptchaNotFoundException();
    }
}

