/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.mojo;

import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.utils.FieldUtils;
import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import com.baidu.bjf.remoting.protobuf.utils.compiler.JdkCompiler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jodd.io.findfile.ClassFinder;
import jodd.io.findfile.ClassScanner;
import org.apache.commons.io.FileUtils;

public class JprotobufPreCompileMain {
    public static void main(String[] args) {
        if (args == null || args.length == 0 || args.length != 3) {
            throw new RuntimeException(JprotobufPreCompileMain.printUsage());
        }
        final File outputPath = new File(String.valueOf(args[0]) + File.separator + "temp");
        try {
            FileUtils.deleteDirectory((File)outputPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputPath.mkdirs();
        JDKCompilerHelper.setCompiler((Compiler)new JdkCompiler(Thread.currentThread().getContextClassLoader()));
        final String filterClassPackage = args[2];
        ClassScanner scanner = new ClassScanner(){

            protected void onEntry(ClassFinder.EntryData entryData) throws Exception {
                String name = entryData.getName();
                if (filterClassPackage != null && !name.startsWith(filterClassPackage)) {
                    return;
                }
                Class c = JprotobufPreCompileMain.getByClass(name);
                if (c == null) {
                    return;
                }
                try {
                    List fields = FieldUtils.findMatchedFields((Class)c, Protobuf.class);
                    if (!fields.isEmpty()) {
                        ProtobufProxy.create((Class)c, (boolean)false, (File)outputPath);
                    }
                }
                catch (Throwable e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
        };
        scanner.scanDefaultClasspath();
        try {
            FileUtils.copyDirectory((File)outputPath, (File)new File(args[1]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String printUsage() {
        return "Usage: " + JprotobufPreCompileMain.class.getName() + " outputFile";
    }

    private static Class getByClass(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

