/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.bean;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ExpressionType;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.bean.SubscriptionExt;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;

public class ConsumerBean
implements Consumer {
    private Properties properties;
    private Map<Subscription, MessageListener> subscriptionTable;
    private Consumer consumer;

    @Override
    public void start() {
        if (null == this.properties) {
            throw new ONSClientException("properties not set");
        }
        if (null == this.subscriptionTable) {
            throw new ONSClientException("subscriptionTable not set");
        }
        this.consumer = ONSFactory.createConsumer(this.properties);
        block2: for (Map.Entry<Subscription, MessageListener> next : this.subscriptionTable.entrySet()) {
            Subscription subscription;
            if (this.consumer.getClass().getCanonicalName().equals("com.aliyun.openservices.ons.api.impl.notify.ConsumerImpl") && next.getKey() instanceof SubscriptionExt) {
                subscription = (SubscriptionExt)next.getKey();
                for (Method method : this.consumer.getClass().getMethods()) {
                    if (!"subscribeNotify".equals(method.getName())) continue;
                    try {
                        method.invoke((Object)this.consumer, subscription.getTopic(), subscription.getExpression(), ((SubscriptionExt)subscription).isPersistence(), next.getValue());
                        continue block2;
                    }
                    catch (Exception e) {
                        throw new ONSClientException("subscribeNotify invoke exception", e);
                    }
                }
                continue;
            }
            subscription = next.getKey();
            if (subscription.getType() == null || ExpressionType.TAG.name().equals(subscription.getType())) {
                this.subscribe(subscription.getTopic(), subscription.getExpression(), next.getValue());
                continue;
            }
            if (ExpressionType.SQL92.name().equals(subscription.getType())) {
                this.subscribe(subscription.getTopic(), MessageSelector.bySql(subscription.getExpression()), next.getValue());
                continue;
            }
            throw new ONSClientException(String.format("Expression type %s is unknown!", subscription.getType()));
        }
        this.consumer.start();
    }

    @Override
    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
    }

    @Override
    public void subscribe(String topic, String subExpression, MessageListener listener) {
        if (null == this.consumer) {
            throw new ONSClientException("subscribe must be called after consumerBean started");
        }
        this.consumer.subscribe(topic, subExpression, listener);
    }

    @Override
    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        if (null == this.consumer) {
            throw new ONSClientException("subscribe must be called after consumerBean started");
        }
        this.consumer.subscribe(topic, selector, listener);
    }

    @Override
    public void unsubscribe(String topic) {
        if (null == this.consumer) {
            throw new ONSClientException("unsubscribe must be called after consumerBean started");
        }
        this.consumer.unsubscribe(topic);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<Subscription, MessageListener> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public void setSubscriptionTable(Map<Subscription, MessageListener> subscriptionTable) {
        this.subscriptionTable = subscriptionTable;
    }

    @Override
    public boolean isStarted() {
        return this.consumer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return this.consumer.isClosed();
    }
}

