/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.model.serialize.topic;

import com.aliyun.mns.common.utils.BooleanSerializer;
import com.aliyun.mns.model.MessageAttributes;
import com.aliyun.mns.model.TopicMessage;
import com.aliyun.mns.model.request.topic.PublishMessageRequest;
import com.aliyun.mns.model.serialize.XMLSerializer;
import com.aliyun.mns.model.serialize.XmlUtil;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopicMessageSerializer
extends XMLSerializer<PublishMessageRequest> {
    private static Gson gson = null;

    private synchronized Gson getGson() {
        if (gson == null) {
            GsonBuilder b = new GsonBuilder();
            b.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
            BooleanSerializer serializer = new BooleanSerializer();
            b.registerTypeAdapter(Boolean.class, (Object)serializer);
            b.registerTypeAdapter(Boolean.TYPE, (Object)serializer);
            gson = b.create();
        }
        return gson;
    }

    @Override
    public InputStream serialize(PublishMessageRequest request, String encoding) throws Exception {
        MessageAttributes messageAttributes;
        Document doc = this.getDocmentBuilder().newDocument();
        TopicMessage msg = request.getMessage();
        Element root = doc.createElementNS("http://mns.aliyuncs.com/doc/v1", "Message");
        doc.appendChild(root);
        Element node = this.safeCreateContentElement(doc, "MessageBody", msg.getMessageBody(), "");
        if (node != null) {
            root.appendChild(node);
        }
        if ((node = this.safeCreateContentElement(doc, "MessageTag", msg.getMessageTag(), null)) != null) {
            root.appendChild(node);
        }
        if ((messageAttributes = request.getMessageAttributes()) != null && messageAttributes.getMailAttributes() != null) {
            Element attributesNode = doc.createElement("MessageAttributes");
            root.appendChild(attributesNode);
            node = this.safeCreateContentElement(doc, "DirectMail", messageAttributes.getMailAttributes().toJson(this.getGson()), null);
            if (node != null) {
                attributesNode.appendChild(node);
            }
        }
        String xml = XmlUtil.xmlNodeToString(doc, encoding);
        return new ByteArrayInputStream(xml.getBytes(encoding));
    }
}

