/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mns.common.http;

import com.aliyun.mns.client.AsyncCallback;
import com.aliyun.mns.client.AsyncResult;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.http.ResponseMessage;
import com.aliyun.mns.common.parser.ResultParser;
import com.aliyun.mns.common.utils.HttpUtil;
import com.aliyun.mns.common.utils.IOUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

public class HttpCallback<T>
implements FutureCallback<HttpResponse> {
    private static Log log = LogFactory.getLog(HttpCallback.class);
    private boolean success = false;
    private Exception exception = null;
    private ResponseMessage responseMessage = null;
    private boolean cancalled = false;
    private ResultParser<T> resultParser;
    private AsyncCallback<T> callback;
    private DefaultAsyncResult<T> result;
    private ResultParser<Exception> exceptionParser;

    public HttpCallback(ResultParser<T> resultParser, ResultParser<Exception> exceptionParser, AsyncCallback<T> callback) {
        this.resultParser = resultParser;
        this.callback = callback;
        this.exceptionParser = exceptionParser;
        this.result = new DefaultAsyncResult(this);
    }

    public void completed(HttpResponse response) {
        try {
            this.buildResponseMessage(response);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
            if (this.callback != null) {
                this.callback.onFail(ex);
            }
            this.result.onFail(ex);
            log.error((Object)"onFail finish when exception in completed");
        }
    }

    protected void buildResponseMessage(HttpResponse response) {
        this.responseMessage = new ResponseMessage();
        if (response.getStatusLine() != null) {
            this.responseMessage.setStatusCode(response.getStatusLine().getStatusCode());
        }
        if (response.getEntity() != null) {
            try {
                this.responseMessage.setContent(response.getEntity().getContent());
            }
            catch (IllegalStateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            resultHeaders.put(h.getName(), h.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(resultHeaders);
        this.responseMessage.setHeaders(resultHeaders);
        this.handleResult();
    }

    private void close() {
        if (this.responseMessage != null) {
            try {
                this.responseMessage.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleResult() {
        try {
            if (this.responseMessage.isSuccessful()) {
                Object obj = null;
                if (this.resultParser != null) {
                    obj = this.resultParser.parse(this.responseMessage);
                }
                if (this.callback != null) {
                    this.callback.onSuccess(obj);
                }
                this.result.onSuccess(obj);
                this.success = true;
            } else {
                Exception obj = this.exceptionParser.parse(this.responseMessage);
                if (this.callback != null) {
                    this.callback.onFail(obj);
                }
                this.result.onFail(obj);
            }
        }
        catch (Exception ex) {
            try {
                System.out.println(IOUtils.readStreamAsString(this.responseMessage.getContent(), "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.callback != null) {
                this.callback.onFail(ex);
            }
            this.result.onFail(ex);
        }
    }

    public void failed(Exception ex) {
        this.exception = ex;
        try {
            if (this.callback != null) {
                this.callback.onFail(ex);
            }
            this.result.onFail(ex);
        }
        catch (Exception e) {
            if (this.callback != null) {
                this.callback.onFail(e);
            }
            this.result.onFail(e);
        }
    }

    public void cancelled() {
        this.cancalled = true;
        this.exception = new ClientException("call is cancelled.");
        try {
            if (this.callback != null) {
                this.callback.onFail(this.exception);
            }
            this.result.onFail(this.exception);
        }
        catch (Exception e) {
            if (this.callback != null) {
                this.callback.onFail(e);
            }
            this.result.onFail(e);
        }
    }

    public boolean isCancelled() {
        return this.cancalled;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Exception getException() {
        return this.exception;
    }

    public ResponseMessage getResponseMessage() {
        return this.responseMessage;
    }

    public AsyncResult<T> getAsyncResult() {
        return this.result;
    }

    static class DefaultAsyncResult<T>
    implements AsyncResult<T> {
        private ReentrantLock rlock = new ReentrantLock();
        private Condition lock = this.rlock.newCondition();
        private long defaultTimewait;
        private long startTimeMillis;
        private boolean completed = false;
        private T result = null;
        private boolean success;
        private Exception exception;
        private HttpCallback<T> callback;
        private Future<HttpResponse> future;

        protected DefaultAsyncResult(HttpCallback<T> callback) {
            this.callback = callback;
            this.startTimeMillis = System.currentTimeMillis();
        }

        @Override
        public void setTimewait(long timewait) {
            this.defaultTimewait = timewait;
        }

        @Override
        public void setFuture(Future<HttpResponse> future) {
            this.future = future;
        }

        @Override
        public T getResult() {
            T result = this.getResult(this.defaultTimewait);
            while (result == null && this.future != null && !this.future.isDone()) {
                result = this.getResult(this.defaultTimewait);
            }
            return result;
        }

        @Override
        public T getResult(long timewait) {
            if (!this.completed) {
                try {
                    this.rlock.lock();
                    if (!this.completed) {
                        boolean signaled = false;
                        signaled = timewait <= 0L ? this.lock.await(this.defaultTimewait, TimeUnit.MILLISECONDS) : this.lock.await(timewait, TimeUnit.MILLISECONDS);
                        if (!signaled && this.future != null && this.future.isDone() && System.currentTimeMillis() >= this.startTimeMillis + this.defaultTimewait) {
                            this.exception = new ClientException("Client wait result timeout!");
                            this.success = false;
                            this.completed = true;
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.rlock.unlock();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(T result) {
            try {
                this.rlock.lock();
                this.result = result;
                this.success = true;
                this.completed = true;
                this.lock.signal();
            }
            finally {
                this.rlock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFail(Exception ex) {
            try {
                this.rlock.lock();
                this.exception = ex;
                this.success = false;
                this.completed = true;
                this.lock.signal();
            }
            finally {
                this.rlock.unlock();
            }
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        public void close() {
            ((HttpCallback)this.callback).close();
        }
    }
}

