/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.sms;

import cn.javaer.aliyun.sms.SmsTemplate;
import cn.javaer.aliyun.sms.Utils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class SmsClient {
    private final IAcsClient acsClient;
    private final String product = "Dysmsapi";
    private final String domain = "dysmsapi.aliyuncs.com";
    private final String region = "cn-hangzhou";
    private final String endpointName = "cn-hangzhou";
    private final Map<String, SmsTemplate> smsTemplates;

    public SmsClient(String accessKeyId, String accessKeySecret) {
        this(accessKeyId, accessKeySecret, Collections.emptyMap());
    }

    public SmsClient(String accessKeyId, String accessKeySecret, Map<String, SmsTemplate> smsTemplates) {
        Utils.checkNotEmpty(accessKeyId, "'accessKeyId' must be not empty");
        Utils.checkNotEmpty(accessKeySecret, "'accessKeySecret' must be not empty");
        Objects.requireNonNull(this);
        DefaultProfile clientProfile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        Utils.tryChecked(() -> {
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)this.product, (String)this.domain);
        });
        this.acsClient = new DefaultAcsClient((IClientProfile)clientProfile);
        this.smsTemplates = smsTemplates;
    }

    public int sendVerificationCode(String smsTemplateKey, String phoneNumber) {
        Utils.checkPhoneNumber(phoneNumber);
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        int code = Utils.randomCode();
        smsTemplate.setTemplateParam(Collections.singletonMap("code", String.valueOf(code)));
        smsTemplate.setPhoneNumbers(Collections.singletonList(phoneNumber));
        this.send(smsTemplate);
        return code;
    }

    public void send(String smsTemplateKey) {
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        this.send(smsTemplate);
    }

    public void send(String smsTemplateKey, String ... phoneNumbers) {
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
    }

    public void send(SmsTemplate smsTemplate) {
        Objects.requireNonNull(smsTemplate);
        Utils.checkSmsTemplate(smsTemplate);
        SendSmsRequest request = new SendSmsRequest();
        request.setMethod(MethodType.POST);
        request.setPhoneNumbers(String.join((CharSequence)",", smsTemplate.getPhoneNumbers()));
        request.setSignName(smsTemplate.getSignName());
        request.setTemplateCode(smsTemplate.getTemplateCode());
        request.setTemplateParam(Utils.toJsonStr(smsTemplate.getTemplateParam()));
        SendSmsResponse response = Utils.tryChecked(() -> (SendSmsResponse)this.acsClient.getAcsResponse((AcsRequest)request));
        Utils.checkSmsResponse(response);
    }
}

