/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.nutz.lang.Nums;

public class Numbers
extends Nums {
    public static String format(double number, int precision) {
        if (number == 0.0) {
            String temp = "0.";
            for (int i = 0; i < precision; ++i) {
                temp = temp + "0";
            }
            return temp;
        }
        number = Numbers.keepPrecision(number, precision);
        String base = "###,###.";
        for (int i = 0; i < precision; ++i) {
            base = base + "#";
        }
        DecimalFormat formatter = new DecimalFormat(base);
        String target = formatter.format(number);
        int ps = 0;
        if (target.split("\\.").length > 1) {
            ps = target.split("\\.")[1].length();
        } else {
            if (precision == 0) {
                return target.substring(0, target.length() - 1);
            }
            target = target + ".";
        }
        if (ps != precision) {
            for (int i = 0; i < precision - ps; ++i) {
                target = target + "0";
            }
        }
        return target;
    }

    public static String format(float number, int precision) {
        if (number == 0.0f) {
            String temp = "0.";
            for (int i = 0; i < precision; ++i) {
                temp = temp + "0";
            }
            return temp;
        }
        number = Numbers.keepPrecision(number, precision);
        String base = "###,###.";
        for (int i = 0; i < precision; ++i) {
            base = base + "#";
        }
        DecimalFormat formatter = new DecimalFormat(base);
        String target = formatter.format(number);
        int ps = 0;
        if (target.split("\\.").length > 1) {
            ps = target.split("\\.")[1].length();
        } else {
            if (precision == 0) {
                return target.substring(0, target.length() - 1);
            }
            target = target + ".";
        }
        if (ps != precision) {
            for (int i = 0; i < precision - ps; ++i) {
                target = target + "0";
            }
        }
        return target;
    }

    public static String format(Number number, int precision) {
        return Numbers.format(number.toString(), precision);
    }

    public static String format(String num, int precision) {
        return Numbers.format(Double.parseDouble(num), precision);
    }

    @Deprecated
    public static String formatPrecission(String number, int precision) {
        return Numbers.format(number, precision);
    }

    public static double keepPrecision(double number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).doubleValue();
    }

    public static float keepPrecision(float number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).floatValue();
    }

    public static String keepPrecision(Number number, int precision) {
        return Numbers.keepPrecision(String.valueOf(number), precision);
    }

    public static String keepPrecision(String number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).toPlainString();
    }

    public static void main(String[] args) {
        System.err.println(Numbers.keepPrecision(0.0, 2));
    }
}

