package com.atlascopco.service.impl;

import com.atlascopco.model.Atlascopco;
import com.atlascopco.service.AtlascopcoService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class AtlascopcoServiceImpl extends BaseDaoServiceImpl implements AtlascopcoService {

 

	private static final Log log = LogFactory.getLog(AtlascopcoServiceImpl.class);



		   
		@Override
		public Long insert(Atlascopco atlascopco)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + atlascopco);

		if (atlascopco == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		atlascopco.setCreateAt(currentTimeMillis);
		atlascopco.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(atlascopco);
		} catch (DaoException e) {
			log.error(" insert wrong : " + atlascopco);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Atlascopco> insertList(List<Atlascopco> atlascopcoList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (atlascopcoList == null ? "null" : atlascopcoList.size()));
      
		List<Atlascopco> resultList = null;

		if (CollectionUtils.isEmpty(atlascopcoList)) {
			return new ArrayList<Atlascopco>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Atlascopco atlascopco : atlascopcoList) {
			atlascopco.setCreateAt(currentTimeMillis);
			atlascopco.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Atlascopco>) dao.batchSave(atlascopcoList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + atlascopcoList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Atlascopco.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Atlascopco atlascopco)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (atlascopco == null ? "null" : atlascopco.getId()));

		boolean result = false;

		if (atlascopco == null) {
			return true;
		}

		atlascopco.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(atlascopco);
		} catch (DaoException e) {
			log.error(" update wrong : " + atlascopco);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + atlascopco);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Atlascopco> atlascopcoList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (atlascopcoList == null ? "null" : atlascopcoList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(atlascopcoList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Atlascopco atlascopco : atlascopcoList) {
			atlascopco.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(atlascopcoList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + atlascopcoList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + atlascopcoList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Atlascopco getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Atlascopco atlascopco = null;

		if (id == null) {
			return atlascopco;
		}

		try {
			atlascopco = (Atlascopco) dao.get(Atlascopco.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return atlascopco;		
		}	
		  
    	   
		@Override
		public List<Atlascopco> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Atlascopco> atlascopco = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Atlascopco>();
		}

		try {
			atlascopco = (List<Atlascopco>) dao.getList(Atlascopco.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (atlascopco == null ? "null" : atlascopco.size()));
    
		return atlascopco;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getAtlascopcoIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getAtlascopcoIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countAtlascopcoIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getAtlascopcoIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getAtlascopcoIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

